package com.sample;

import java.util.Objects;

public class Mail {
	private Person sender, recipient;
	private String body;
	
	public Mail(Person s, Person r, String b) {
		this.sender = s;
		this.recipient = r;
		this.body = b;
	}
	
	public Person getSender() {
		return sender;
	}
	public void setSender(Person sender) {
		this.sender = sender;
	}
	public Person getRecipient() {
		return recipient;
	}
	public void setRecipient(Person recipient) {
		this.recipient = recipient;
	}
	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}
	@Override
	public int hashCode() {
		return Objects.hash(body, recipient, sender);
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Mail other = (Mail) obj;
		return Objects.equals(body, other.body) && Objects.equals(recipient, other.recipient)
				&& Objects.equals(sender, other.sender);
	}
	@Override
	public String toString() {
		return "Mail [sender=" + sender + ", recipient=" + recipient + ", body=" + body + "]";
	}
	
	
	
	
}
