package com.sample;

import java.util.Iterator;

import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class Test {

	public static void main(String[] args) {
		
		KieServices ks = KieServices.Factory.get();
	    KieContainer kContainer = ks.getKieClasspathContainer();
        KieSession ksession = kContainer.newKieSession("ksession-rules");
        
		Person p1 = new Person("Bob", 35);
		Person p2 = new Person("Molly", 22);
		Person p3 = new Person("Bob", 8);
		Person p4 = new Person("Anna", 15);
		Person p5 = new Person("Bob", 25);
		Person p6 = new Person("Sandra", 40);
		ksession.insert(p1);
		ksession.insert(p2);
		ksession.insert(p3);
		ksession.insert(p4);
		ksession.insert(p5);
		ksession.insert(p6);
		ksession.insert(new Mail(p1, p4, 
		  "Do your homeworks!"));
		ksession.insert(new Mail(p5, p5,
		  "Remember to do the homeworks!"));
		 
		ksession.fireAllRules();
		QueryResults result = ksession.getQueryResults("under18");
		for ( QueryResultsRow row : result ) {
		    Person person = ( Person ) row.get( "$res" );
		    System.out.println( person + "\n" );
		}
	}
}
