package com.example.demo;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


@RestController
public class UserController {

	@Autowired    
	private UserService userService;     
	@RequestMapping("/")    
	public List<UserRecord> getAllUser()  
	{    
		return userService.getAllUsers();    
	}       
	@RequestMapping(value="/add-user", method=RequestMethod.POST)    
	public void addUser(@RequestBody UserRecord userRecord)  
	{    
		userService.addUser(userRecord);    
	}       
	
	@GetMapping("/user/{id}")
	public Optional<UserRecord> getUser(@PathVariable("id") String id) {
		return userService.getUser(id);
	}
	
	@DeleteMapping("/user/{id}")
	public ResponseEntity<String> DeleteUser(@PathVariable("id") String id) {
		userService.deleteUser(id);
		return new ResponseEntity<>("User is Deleted successsfully", HttpStatus.OK);
	}
}
