package com.example.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import jakarta.websocket.server.PathParam;

@RestController
public class ProductServiceController {
	private static Map<String, Product> productRepo=new HashMap<>();
	static {
		Product honey = new Product();
		honey.setId("1");
		honey.setName("penna");
		productRepo.put(honey.getId(), honey);




		Product almond = new Product();
		almond.setId("2");
		almond.setName("libro");
		productRepo.put(almond.getId(), almond);


	}


	//@DeleteMapping("/products/{id}")
	@RequestMapping(value = "/products/{id}", method = RequestMethod.DELETE)
	public ResponseEntity<Object> delete(@PathVariable("id") String id) { 
		productRepo.remove(id);
		return new ResponseEntity<>("Product is deleted successsfully", HttpStatus.OK);
	}

	@RequestMapping(value = "/products/{id}", method = RequestMethod.PUT)
	public ResponseEntity<Object> updateProduct(@PathVariable("id") String id, @RequestBody Product product) { 
		productRepo.remove(id);
		product.setId(id);
		productRepo.put(id, product);
		return new ResponseEntity<>("Product is updated successsfully", HttpStatus.OK);
	}

	@RequestMapping(value = "/products", method = RequestMethod.POST)
	public ResponseEntity<Object> createProduct(@RequestBody Product product) {
		if(!productRepo.containsKey(product.getId())) {
			productRepo.put(product.getId(), product);
			return new ResponseEntity<>("Product is created successfully", HttpStatus.CREATED);
		}else {
			return new ResponseEntity<>("Product already exists", HttpStatus.BAD_REQUEST);
		}
	}

	@RequestMapping(value = "/products")
	public ResponseEntity<Object> getProducts() {
		return new ResponseEntity<>(productRepo.values(), HttpStatus.OK);
	}
	@GetMapping("/product/{id}")
	public ResponseEntity<Object> getProduct(@PathVariable("id") String id) {
		return new ResponseEntity<>(productRepo.get(id), HttpStatus.OK);
	}

	@GetMapping("/getProduct")
	public ResponseEntity<Object> product(@PathParam("id") String id) {
		System.out.println("ID  "+id);

		return new ResponseEntity<>(productRepo.get(id), HttpStatus.OK);
	}
	
	@RequestMapping(value = "/upload", method = RequestMethod.POST, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
	   
	   public String fileUpload(@RequestParam("file") MultipartFile file, @RequestParam("name") String n) throws IOException {
	      File convertFile = new File("/var/tmp/"+file.getOriginalFilename());
	      convertFile.createNewFile();
	      FileOutputStream fout = new FileOutputStream(convertFile);
	      fout.write(file.getBytes());
	      fout.close();
	      return "File is upload successfully "+n;
	   }
	
	 @RequestMapping(value = "/download/{filename}", method = RequestMethod.GET) 
	   public ResponseEntity<Object> downloadFile(@PathVariable("filename") String f) throws IOException  {
	      String filename = "/var/tmp/"+f;
	      System.out.println(filename);
	      File file = new File(filename);
	      InputStreamResource resource = new InputStreamResource(new FileInputStream(file));
	      HttpHeaders headers = new HttpHeaders();
	         
	      headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", file.getName()));
	      headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
	      headers.add("Pragma", "no-cache");
	      headers.add("Expires", "0");
	         
	      ResponseEntity<Object> 
	      responseEntity = ResponseEntity.ok().headers(headers).contentLength(file.length()).contentType(
	         MediaType.parseMediaType("application/txt")).body(resource);
	         
	      return responseEntity;
	   }
}
