package it.unicam.cs.cmp1819.recdescparser;

import java.util.List;

/**
 * Simple ad hoc recursive descent parser for a specific grammar. 
 * 
 * @author Luca Tesei
 *
 */
public class StmtAndOptexprRecursiveDescentParser {

    /**
     * Parse a string of tokens with respect to the grammar: 
     * {@code
     * stmt ::= <expr> <;> |
     *          <if> <(> <expr> <)> stmt |
     *          <for> <(> optexpr <;> optexpr <;> optexpr <)> stmt |
     *          <other>
     * optexpr ::= <expr> | epsilon         
     * }
     * Tokens are the symbols inside < and >. The parser is recursive descent 
     * and the strategy for choosing the productions to use is ad hoc.
     * 
     * @param input a list of tokens to parse
     * @return true if the list of tokens is correctly parsed, false otherwise.
     */
    public boolean parse(List<Token> input) {
        stmt(input);
        if (input.isEmpty())
            return true;
        else
            return false;

    }

    /*
     * Expand a node stmt. Consumes the input or call the methods associated to
     * non-terminal symbols. This method is recursive.
     */
    private void stmt(List<Token> input) {
        List<Object> rightPartOfChosenProduction = chooseProductionForStmt(
                input);
        // TODO implement the scheme procedure
    }

    /*
     * Expand a node optexpr. Consumes the input or call the methods associated
     * to non-terminal symbols. This method is not recursive as the two
     * productions of optexpr are not recursive.
     */
    private void optexpr(List<Token> input) {
        List<Object> rightPartOfChosenProduction = chooseProductionForOptexpr(
                input);
        // TODO implement the scheme procedure
    }

    /*
     * Choose the right production to use basing on input and return the right
     * part of production as a list of objects: tokens or strings ("stmt" or
     * "optexpr", i.e., the only two non-terminal symbols).
     */
    private List<Object> chooseProductionForStmt(List<Token> input) {
        // TODO implement an ad hoc chosing strategy
        return null;
    }

    /*
     * Choose the right production to use basing on input and return the right
     * part of production as a list of objects: tokens or strings ("stmt" or
     * "optexpr", i.e., the only two non-terminal symbols).
     */
    private List<Object> chooseProductionForOptexpr(List<Token> input) {
        // TODO implement an ad hoc choosing strategy
        return null;
    }

}
