package it.unicam.cs.cmp1819.recdescparser;

public class Token {
    /**
     * Constants for the token ids of the element of the given grammar.
     */
    public static final int EXPR_TOKEN_ID = 1;
    public static final int SEMICOLON_TOKEN_ID = 2;
    public static final int IF_TOKEN_ID = 3;
    public static final int OPEN_BRACKET_TOKEN_ID = 4;
    public static final int CLOSED_BRACKET_TOKEN_ID = 5;
    public static final int FOR_TOKEN_ID = 6;
    public static final int OTHER_TOKEN_ID = 7;
    
    private final int TokenID;
    private final String TokenLexeme;
    private final Object TokenAttribute;
    
    /**
     * @param tokenID
     * @param tokenLexeme
     * @param tokenAttribute
     */
    public Token(int tokenID, String tokenLexeme, Object tokenAttribute) {
        TokenID = tokenID;
        TokenLexeme = tokenLexeme;
        TokenAttribute = tokenAttribute;
    }
    /**
     * @return the tokenID
     */
    public int getTokenID() {
        return TokenID;
    }
    /**
     * @return the tokenLexeme
     */
    public String getTokenLexeme() {
        return TokenLexeme;
    }
    /**
     * @return the tokenAttribute
     */
    public Object getTokenAttribute() {
        return TokenAttribute;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((TokenAttribute == null) ? 0 : TokenAttribute.hashCode());
        result = prime * result + TokenID;
        result = prime * result
                + ((TokenLexeme == null) ? 0 : TokenLexeme.hashCode());
        return result;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Token))
            return false;
        Token other = (Token) obj;
        if (TokenAttribute == null) {
            if (other.TokenAttribute != null)
                return false;
        } else if (!TokenAttribute.equals(other.TokenAttribute))
            return false;
        if (TokenID != other.TokenID)
            return false;
        if (TokenLexeme == null) {
            if (other.TokenLexeme != null)
                return false;
        } else if (!TokenLexeme.equals(other.TokenLexeme))
            return false;
        return true;
    }
    

}
