% We 'flatten' a list by removing all the square brackets around any lists
% it contains as elements, and around any lists that its elements contain
% as elements, and so on for all nested lists. For example, when we flatten
% the list [a,b,[c,d],[[1,2]],foo] we get the list [a,b,c,d,1,2,foo] and
% when we flatten the list [a,b,[[[[[[[c,d]]]]]]],[[1,2]],foo,[]] we also
% get [a,b,c,d,1,2,foo].

% Write a predicate my_flatten(List,Flat) that holds when the first argument
% List flattens to the second argument Flat. Try to come up with a method
% using append.

%Caso base: secondo e terzo parametro sono uguali
flatten([], R, R).

%Caso in cui il primo parametro è una lista
flatten([H|T], A, R) :-
    %Eseguo il flatten sulla tail fino in fondo (2°p: A, 3°p: X)
    flatten(T, A, X),
    %Eseguo poi il flatten su H (2°p: X, 3°p: R)
    flatten(H, X, R).

%Caso in cui il primo parametro è un elemento
%Il flatten per concatenare l'elemento X con la lista A.
flatten(X, A, [X|A]) :-
    not(is_list(X)).

% Wrapper
flatten(L, R) :-
    flatten(L, [], R).



%ANOTHER SOLUTION WITH A PROBLEM: TOO MUCH RESULTS!!!!

%Caso lista vuota
flatten2([],[]).
%Caso lista con valori: divido la lista in input in Head e Tail, poi eseguo
%prima il flatted della Head (così facendo posso entrare nei casi: 1/2/3),
%successivamente eseguo la stessa operazione sulla Tail (così facendo posso
%entrare nei casi 1/2), quando ho finito ad eseguire il flatten dell'Head
%iniziale e del Tail iniziale allora unisco NewH e NewT, ciò produrrà la nostra
%FlattedList.
%NB Problemino: I risultati sono multipli, però il primo risultato è sempre
%quello desiderato!
%NB Consiglio trovato su internet: Aggiungi il "!" per fermare il backtracking
flatten2([H|T], FlattedList) :-
    flatten2(H, NewH),
    flatten2(T, NewT),
    append(NewH, NewT, FlattedList).
% Caso single element: vediamo un elemento singolo X, come una lista con X
flatten2(X, [X]).


/*
Idealmente il predicato flatten/3 deve essere visto come l'espressione flatten
con 3 parametri:
- Lista di input
- Working List
- Lista di output

La prima regola dice che se non ci sono più elementi nella lista di input del
flatten allora il risultato è nel secondo parametro che contiene la flatten list
flatten([], R, R).

La seconda regola dice che se ho una lista no-flatten come primo parametro
(composta dell'elemento H e della lista T) ed una flatten list come secondo
parametro (lista A), prima di tutto puoi eseguire il flatten di T ed A ottenendo
X (induttivamente X è una flat list), e poi tu puoi eseguire il flatten di H
ed X ottenendo l'output finale R.
flatten([H|T], A, R) :- flatten(T, A, X), flatten(H, X, R).

La terza regola dice che se a sinistra ho un elemento (non-lista) come X e come
A una flatten list, puoi facilmente ottenere una flatten list accodando X ad A.
flatten(X, A, [X|A]) :- not(is_list(X)).

la quarta regola dice semplicemente che possiamo creare un wrapper di flatten/3
passando un input non-flat come primo parametro ed una variabile come secondo
perciò avremo una flatten/2.
Dentro verrà chiamato il flatten/3 ed avrà come parametri:
  1- Lista non-flat (1° parametro di flatten/2)
  2- Lista vuota come working list
  3- Lista flat (2° parametro di flatten/2)
flatten(L, R) :-flatten(L, [], R).
*/


/*
Esempi:
flatten([5,2,a,v,[[[[[[[[[[[[[[[[[[[[[3]]]]]]]]]]]]]]]]]]]]],[4,[[7,4,2]],y]],X).

*/




flatten3([],[]).
flatten3([H|T],Flat) :- flatten3(H,H1), flatten3(T,T1), append(H1,T1,Flat).
%Dico semplicemente che H non è una lista quindi H non unifica con [] o con [_|_]
flatten3([H|T],[H|T1]) :- H \= [], H \= [_|_], flatten3(T,T1).
