% Define a predicate remove(X,InList,OutList) such that OutList is obtained
% by removing the first occurrence of X from InList. If X does not occur
% in InList, just return the list as it is.

% Note, that the predicate is supposed to only remove the first occurrence
% of the specified element. So, you need the cut to stop Prolog from
% backtracking and deleting later occurrences as well.

%%% SOLUTION WITHOUT CUT

% remove(X,[],[]).

% remove(X,[X|T],T).

% remove(X,[H|T],[H|T1]) :- X \= H, remove(X,T,T1).


%%% SOLUTION WITH CUT

remove(X,[],[]).

remove(X,[X|T],T) :- !.

remove(X,[H|T],[H|T1]) :- remove(X,T,T1).

% remove(1,[1,2,3,4],X).
% remove(2,[1,2,3,4],X).
% remove(4,[1,2,3,4],X).
% remove(13,[1,2,3,4],X).
% remove(2,[1,2,3,2,4,2],X).
