% Here are six English words:
% abalone, abandon, anagram, connect, elegant, enhance.

% They are to be arranged in a crossword puzzle like fashion in the
% grid given below.


% The following knowledge base represents a lexicon containing these words.

word(abalone,a,b,a,l,o,n,e).
word(abandon,a,b,a,n,d,o,n).
word(enhance,e,n,h,a,n,c,e).
word(anagram,a,n,a,g,r,a,m).
word(connect,c,o,n,n,e,c,t).
word(elegant,e,l,e,g,a,n,t).

% Write a predicate crosswd/6 that tells us how to fill the grid,
% i.e. the first three arguments should be the vertical words
% from left to right and the following three arguments the horizontal
% words from top to bottom.

% Predicate crosswd/6:

% crosswd(
%  word(W1,W11,W12,W13,W14,W15,W16,W17),
%  word(W2,W21,W22,W23,W24,W25,W26,W27),
%  word(W3,W31,W32,W33,W34,W35,W36,W37),
%  word(W4,W41,W42,W43,W44,W45,W46,W47),
%  word(W5,W51,W52,W53,W54,W55,W56,W57),
%  word(W6,W61,W62,W63,W64,W65,W66,W67)) :-
%      word(W1,W11,W42,W13,W52,W15,W62,W17),
%      word(W2,W21,W44,W23,W54,W25,W64,W27),
%      word(W3,W31,W46,W33,W56,W35,W66,W37),
%      word(W4,W41,W42,W43,W44,W45,W46,W47),
%      word(W5,W51,W52,W53,W54,W55,W56,W57),
%      word(W6,W61,W62,W63,W64,W65,W66,W67).

%%% Conditions:
% W12 = W42, W22=W44, W32=W46, W14=W52,
% W24=W54, W34=W56, W16=W62, W26=W64, W36=W66.


% Query for the solution:
% crosswd(word(W1,_,_,_,_,_,_,_),word(W2,_,_,_,_,_,_,_),word(W3,_,_,_,_,_,_,_),word(W4,_,_,_,_,_,_,_),word(W5,_,_,_,_,_,_,_),word(W6,_,_,_,_,_,_,_)).


%%% Cleaned solution:
 crosswd(V1,V2,V3,H1,H2,H3) :-
                word(V1,_,A,_,B,_,C,_),
                word(V2,_,D,_,E,_,F,_),
                word(V3,_,G,_,H,_,I,_),
                word(H1,_,A,_,D,_,G,_),
                word(H2,_,B,_,E,_,H,_),
                word(H3,_,C,_,F,_,I,_).
