% The following KB shows who is sitting at the Gryffindor table.
% The functor sits_right_of/2 represents who is sitting right of whom:
% sits_right_of(X,Y) should be true if X is to the right of Y.

sits_right_of(ron,natalie).
sits_right_of(hermione,ron).
sits_right_of(harry,hermione).
sits_right_of(colin,harry).
sits_right_of(seamus,colin).
sits_right_of(angelina,seamus).
sits_right_of(ginny,angelina).
sits_right_of(dean,ginny).
sits_right_of(dennis,dean).
sits_right_of(lee,dennis).
sits_right_of(george,lee).
sits_right_of(fred,george).
sits_right_of(alicia,fred).
sits_right_of(neville,alicia).
sits_right_of(lavender,neville).
sits_right_of(parvati,lavender).
sits_right_of(katie,parvati).
sits_right_of(natalie,katie).

% Based on this KB, formulate the rules defining the following predicates:
% - sits_left_of/2: sits_left_of(X,Y) should be true if X is to the left of Y.

sits_left_of(X,Y) :- sits_right_of(Y,X).

% - are_neighbors_of/3: are_neighbors_of(X,Y,Z) should be true if X is to the
%   left of Z and Y is to the right of Z.

are_neighbors_of(X,Y,Z) :- sits_left_of(X,Z),sits_right_of(Y,Z).

% - next_to_each_other/2: next_to_each_other(X,Y) should be true if X is next
%   to Y.

next_to_each_other(X,Y) :- sits_left_of(X,Y).
next_to_each_other(X,Y) :- sits_right_of(X,Y).

% Test your implementation by asking queries:
% Is Lavender to the right of Parvati? (true)
sits_right_of(lavender,parvati).

% Is Lavender to the right of Neville? (true)
sits_right_of(lavender,neville).

% Who is to the right of Hermione? (X=ron)
sits_right_of(hermione,X).

% Who is sitting at the table?
sits_right_of(X,_).

% Who is sitting two seats to the right of Hermione? (X = natalie)
sits_right_of(hermione,Y),sits_right_of(Y,X).

% Who is sitting between Neville and Fred? (Z = alicia.)
are_neighbors_of(fred,neville,Z).
