
%%%% Traveling by car, train, and plane

% We are given the following knowledge base of travel information:

byCar(auckland,hamilton).
byCar(hamilton,raglan).
byCar(valmont,saarbruecken).
byCar(valmont,metz).

byTrain(metz,frankfurt).
byTrain(saarbruecken,frankfurt).
byTrain(metz,paris).
byTrain(saarbruecken,paris).

byPlane(frankfurt,bangkok).
byPlane(frankfurt,singapore).
byPlane(paris,losAngeles).
byPlane(bangkok,auckland).
byPlane(losAngeles,auckland).

% Write a predicate travel/2 which determines whether it is possible to travel
% from one place to another by 'chaining together' car, train, and plane
% journeys. For example, your program should answer yes to the query
% travel(valmont,raglan).

direct(X,Y) :- byCar(X,Y).
direct(X,Y) :- byTrain(X,Y).
direct(X,Y) :- byPlane(X,Y).

travel(X,Y) :- direct(X,Y).
travel(X,Y) :- direct(X,Z), travel(Z,Y).



% So, by using travel/2 to query the above database, you can find out that
% it is possible to go from Valmont to Raglan. In case you are planning a
% travel, that's already very good information, but what you would then
% really want to know is how exactly to get from Valmont to Raglan.
% Write a predicate travel/3 which tells you how to travel from one place
% to another. The program should, e.g., answer yes to the query
% travel(valmont,paris,go(valmont,metz,go(metz,paris))) and
% X = go(valmont,metz,go(metz,paris,go(paris,losAngeles)))
% to the query travel(valmont,losAngeles,X).

travel(X,Y,go(X,Y)) :- direct(X,Y).
travel(X,Y,go(X,Z,G)) :- direct(X,Z), travel(Z,Y,G).


% Extend the predicate travel/3 so that it not only tells you via which other
% cities you have to go to get from one place to another, but also how
% (i.e. by car, train, or plane) you get from one city to the next.

directWithInfo(X,Y,'via car') :- byCar(X,Y).
directWithInfo(X,Y,'via train') :- byTrain(X,Y).
directWithInfo(X,Y,'via plane') :- byPlane(X,Y).


travelWithInfo(X,Y,go(X,Y,Via)) :- directWithInfo(X,Y,Via).
travelWithInfo(X,Y,go(X,Z,Via,G)) :- directWithInfo(X,Z,Via), travelWithInfo(Z,Y,G).


% Query: travelWithInfo(valmont,losAngeles,X).
