
% We 'flatten' a list by removing all the square brackets around any lists
% it contains as elements, and around any lists that its elements contain
% as elements, and so on for all nested lists. For example, when we flatten
% the list [a,b,[c,d],[[1,2]],foo] we get the list [a,b,c,d,1,2,foo] and
% when we flatten the list [a,b,[[[[[[[c,d]]]]]]],[[1,2]],foo,[]] we also
% get [a,b,c,d,1,2,foo].

% Write a predicate my_flatten(List,Flat) that holds when the first argument
% List flattens to the second argument Flat. Try to come up with a method
% using append.



my_flatten([],[]).

my_flatten([H|T],Flat) :- my_flatten(H,H1),  my_flatten(T,T1), append(H1,T1,Flat).

my_flatten([H|T],[H|T1]) :-	H \= [], H \= [_|_], my_flatten(T,T1).


% TEST
%  my_flatten([a,b,[c,d],[[1,2]],foo],X).
%  my_flatten([a,b,[[[[[[[c,d]]]]]]],[[1,2]],foo,[]],X).



% ALTERNATIVE SOLUTION
% my_flatten([],[]).
% my_flatten([H1|T1],T2):- H1=[],!,my_flatten(T1,T2).
% my_flatten([H1|T1],T2):- H1=[_|_],!,append(H1,T1,T3),my_flatten(T3,T2).
% my_flatten([H1|T1],[H1|T2]):- H1 \= [_|_], H1 \= [],!, my_flatten(T1,T2).

