% Do NOT use built-in predicates provided by SWI-Prolog.

% Given two li1sts L1 and L2 of integers, write three versions of a predicate 
% union(L1,L2,L) where L is obtained by a specific kind of union of L1 and L2. 
%
%
% Version 1: write the predicate union1(L1,L2,L) where L is obtained by multiset 
% union of L1 and L2 (i.e., L contains all elements of L1 and all elements of L2,
% included duplicated integers). For example, the query union1([1,2,3],[4,2,2,5],L) 
% should return L = [1, 2, 3, 4, 2, 2, 5] (the order of the elements in L is 
% not relevant). 

union1([],L2,L2). 
union1([H|T1],L2,[H|T3]):- union1(T1, L2, T3).


% Version 2: write the predicate union2(L1,L2,L) where L is obtained by set
% union of L1 and L2 (i.e., L contains one occurrence for all elements of L1 and L2,
% hence there is no duplicated integer in L). For example, the query 
% union2([3,1,2,3,3],[4,2,2,5,4],L) should return L = [3, 1, 2, 4, 5] 
% (the order of the elements in L is not relevant). 
% NB: do not care about efficiency.


del(_,[],[]).
del(X,[X|T],T1) :- del(X,T,T1).
del(X,[H|T],[H|T1]) :- H \= X, del(X,T,T1).

removeDuplicates([],[]).
removeDuplicates([H|T],[H|T2]) :- del(H,T,T1), removeDuplicates(T1,T2).

union2(L1,L2,L) :- union1(L1, L2, L3), removeDuplicates(L3,L).






% Version 3: write the predicate union3(L1,L2,L) where L is obtained by disjoint
% union of L1 and L2 (i.e., the union is succeeds only if there is no element in 
% common between L1 and L2, that is their intersection is empty). For example, 
% the query union3([1,2,3,3],[4,5,4],L) should return L = [1, 2, 3, 3, 4, 5, 4] 
% (the order of the elements in L is not relevant), while the query 
% union3([1,2,3,3],[4,3,5,4],L) should return false.
% NB: do not care about efficiency.

notMember(_,[]). 
notMember(X,[H|T]):- X =\= H, notMember(X,T).

union3([],L2,L2). 
union3([H|T1],L2,[H|T3]):- notMember(H,L2), union3(T1, L2, T3).


