% Given a list L of integers, write a predicate filter(L,R) where R is
% obtained from L by removing all numbers that are less than 1.
%
% NB: be careful when more than one solution is asked: 
% it is ok to return "false" (meaning that there is no further solution),
% but it is not ok to return wrong solutions.

filter([],[]).
filter([H|T1],T2) :- H < 1, filter(T1,T2).
filter([H|T1],[H|T2]) :- H > 0, filter(T1,T2).


%% TESTS:
% filter([1,-2,3,12,0,-1,3],L).
% filter([-1,-2,3,12,0,-1,3],L).
% filter([1,-2,3,12,0,-1,-3],L).
% filter([-1,-2,3,12,0,-1,-3],L).
% filter([3,12,4],L).
% filter([-3,-12,-4],L).