/* Mutual exclusion with shared busy variable */
bool busy;
byte mutex;

proctype P(bit i)
{
   atomic { (!busy) -> busy = true}; /* Without atomicity the mutual exclusion is not guaranteed */
	mutex++;
	printf("P%d in critical section\n", i);
	mutex--;
	busy = false;
}

/* Process to check continuously the invariant corresponding to the mutual exclusion property */
active proctype invariant()
{
	assert(mutex <= 1);
}

init
{
atomic {run P(0); run P(1)}
}
	
