/* Peterson's algorithm for mutual exclusion */

bool b1, b2; // control bits
mtype = {P1_Turn, P2_Turn};
mtype x; // turn variable
byte mutex = 0; // variable to check mutual exclusion

active proctype P1(){
	do
	  :: (true) -> skip; /* non-critical section loop */
	  :: x = P2_Turn; b1 = true; 
         /* without atomic mutual exlusion fails*/
	     /* condition check */
         (x==P1_Turn || !b2) -> 
         /* critical section*/ 
         mutex++; 
	     /* exit critical section */
         mutex--;
	     b1 = false
	od
}

active proctype P2(){
	do
	  :: (true) -> skip; /* non-critical section loop */
	  :: x = P1_Turn; b2 = true; 
        /* without atomic mutual exlusion fails */
	    (x==P2_Turn || !b1) -> 
        /* critical section*/ 
        mutex++; 
	    /* exit critical section */ 
        mutex--;
	    b2 = false
	od
}

/* Process to check continuously the invariant 
   condition of mutual exclusion */
active proctype invariant() {
	assert(mutex <= 1)
}






