/**
 * 
 */
package it.unicam.cs.tesei.bankaccounts;

/**
 * Un particolare conto di risparmio vincolato con un tasso aggiuntivo sui mesi
 * in cui l'importo è vincolato
 * 
 * @author luca
 *
 */
public class TimedAccount extends SavingsAccount {
    private int numeroMesiVincolo;

    private int mesiRimanenti;

    private double tassoAggiuntivo;

    /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     */
    public TimedAccount(double saldo, String nome, String codiceFiscale) {
        super(saldo, nome, codiceFiscale);
        // TODO Auto-generated constructor stub
        this.numeroMesiVincolo = 18;
        this.mesiRimanenti = 18;
        this.tassoAggiuntivo = 3.0;
    }

    /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     * @param tassoDiInteresse
     */
    public TimedAccount(double saldo, String nome, String codiceFiscale,
            double tassoDiInteresse) {
        super(saldo, nome, codiceFiscale, tassoDiInteresse);
        // TODO Auto-generated constructor stub
        this.numeroMesiVincolo = 18;
        this.mesiRimanenti = 18;
        this.tassoAggiuntivo = 3.0;
    }

    /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     * @param numeroMesiVincolo
     * @param tassoAggiuntivo
     */
    public TimedAccount(double saldo, String nome, String codiceFiscale,
            int numeroMesiVincolo, double tassoAggiuntivo) {
        super(saldo, nome, codiceFiscale);
        this.numeroMesiVincolo = numeroMesiVincolo;
        this.tassoAggiuntivo = tassoAggiuntivo;
        this.mesiRimanenti = numeroMesiVincolo;
    }

    public void withdraw(double importo) {
        super.withdraw(importo);
        if (this.mesiRimanenti > 0)
            // Rotto il vincolo
            this.mesiRimanenti = 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see it.unicam.cs.tesei.bankaccounts.SavingsAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        // TODO Auto-generated method stub
        super.endOfMonth();
        if (this.mesiRimanenti > 1)
            this.mesiRimanenti--;
        else if (this.mesiRimanenti == 1) {
            // calcolo interesse aggiuntivo
            // Attenzione, calcolo errato
            double interesse = this.getSaldo() * this.tassoAggiuntivo / 100;
            super.deposit(interesse);
            this.mesiRimanenti = 0;
        }
    }

}
