/**
 * 
 */
package it.unicam.cs.tesei.bankaccounts;

/**
 * 
 * Conto corrente di base, senza nessuna particolare caratteristica.
 * 
 * @author luca
 *
 */
public abstract class BankAccount {
    
    private double saldo;
    private String nome;
    private final String codiceFiscale;
    /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     */
    public BankAccount(double saldo, String nome, String codiceFiscale) {
        this.saldo = saldo;
        this.nome = nome;
        this.codiceFiscale = codiceFiscale;
    }
    /**
     * @return the nome
     */
    public String getNome() {
        return nome;
    }
    /**
     * @param nome the nome to set
     */
    public void setNome(String nome) {
        this.nome = nome;
    }
    /**
     * @return the saldo
     */
    public double getSaldo() {
        return saldo;
    }
    /**
     * @return the codiceFiscale
     */
    public String getCodiceFiscale() {
        return codiceFiscale;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((codiceFiscale == null) ? 0 : codiceFiscale.hashCode());
        return result;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof BankAccount))
            return false;
        BankAccount other = (BankAccount) obj;
        if (codiceFiscale == null) {
            if (other.codiceFiscale != null)
                return false;
        } else if (!codiceFiscale.equals(other.codiceFiscale))
            return false;
        return true;
    }
    /**
     * 
     * 
     */
    public abstract void endOfMonth();
    
    public void deposit(double importo){
        if (importo < 0)
            throw new IllegalArgumentException(
                    "Tentativo di deposito di importo negativo");
        saldo += importo;
    }
    
    public void withdraw(double importo){
        if (importo < 0)
            throw new IllegalArgumentException(
                    "Tentativo di prelievo di importo negativo");
        if (importo > saldo)
            throw new InsufficientFundException("Tentativo di prelevare più del posseduto");
        saldo -= importo;
        
    }
    

}
