/**
 * 
 */
package it.unicam.cs.tesei.bankaccounts;

/**
 * Un conto corrente con spese fisse per ogni operazione effettuata
 * @author luca
 *
 */
public class CheckingAccount extends BankAccount {

    private int numeroOperazioni;
    private double costoPerOperazione;
    
    /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     */
    public CheckingAccount(double saldo, String nome, String codiceFiscale) {
        super(saldo, nome, codiceFiscale);
        this.costoPerOperazione = 1.0;
        this.numeroOperazioni = 0;
        // TODO Auto-generated constructor stub
    }

 /**
     * @param saldo
     * @param nome
     * @param codiceFiscale
     * @param costoPerOperazione
     */
    public CheckingAccount(double saldo, String nome, String codiceFiscale,
            double costoPerOperazione) {
        super(saldo, nome, codiceFiscale);
        this.costoPerOperazione = costoPerOperazione;
        this.numeroOperazioni = 0;
    }

   /* (non-Javadoc)
     * @see it.unicam.cs.tesei.bankaccounts.BankAccount#endOfMonth()
     */
    @Override
    public void endOfMonth() {
        // TODO Auto-generated method stub
        double costo = this.numeroOperazioni * this.costoPerOperazione;
        System.out.println("Costo " + costo);
        if (this.getSaldo() < costo)
            throw new InsufficientFundForCostException("SaldoInsufficiente per pagare le spese di operazione");
        super.withdraw(costo);
        this.numeroOperazioni = 0;
    }

    public void deposit(double importo){
        super.deposit(importo);
        this.numeroOperazioni++;
    }
    
    public void withdraw(double importo){
        super.withdraw(importo);
        this.numeroOperazioni++;
    }
    
    
}
