package it.unicam.cs.tesei.graphs;

import java.io.IOException;

import java.util.Iterator;

public class GenericGraphBSFTest {

    public static void main(String[] args) throws IOException {
        Graph<MyNodeBFS, Integer> g = new GraphListUndirected<MyNodeBFS, Integer>();
        MyNodeBFS r = new MyNodeBFS("r");
        MyNodeBFS s = new MyNodeBFS("s");
        MyNodeBFS t = new MyNodeBFS("t");
        MyNodeBFS u = new MyNodeBFS("u");
        MyNodeBFS v = new MyNodeBFS("v");
        MyNodeBFS w = new MyNodeBFS("w");
        MyNodeBFS x = new MyNodeBFS("x");
        MyNodeBFS y = new MyNodeBFS("y");
        g.addNode(r);
        g.addNode(s);
        g.addNode(t);
        g.addNode(u);
        g.addNode(v);
        g.addNode(w);
        g.addNode(x);
        g.addNode(y);
        g.addEdge(r, s, null);
        g.addEdge(r, v, null);
        g.addEdge(s, w, null);
        g.addEdge(t, w, null);
        g.addEdge(x, w, null);
        g.addEdge(t, x, null);
        g.addEdge(x, y, null);
        g.addEdge(t, u, null);
        g.addEdge(u, y, null);
        GenericGraphBFS<MyNodeBFS, Integer> bfsAlgorithm = 
                new GenericGraphBFS<MyNodeBFS, Integer>();
        bfsAlgorithm.BFS(g, s);
        printTree(g,s);
    }
    
    public static void printTree(Graph<MyNodeBFS,Integer> g, MyNodeBFS x) {
        System.out.println("Nodo " + x.toString());
        Iterator<MyNodeBFS> vicini = g.neighbors(x).iterator();
        MyNodeBFS vicino = null;
        while (vicini.hasNext()) {
            vicino = vicini.next();
            if (x.equals(vicino.getFather())) {
                printTree(g,vicino);
            }
        }
    }
    

}
