package it.unicam.cs.tesei.graphs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.Iterator;

/**
 * 
 * @author luca
 *
 * @param <V>
 * @param <E>
 */
public class GenericGraphBFS<V extends GenericBFSNode, E> {
    /**
     * Esegue una visita in ampiezza di un grafo a partire da una sorgente data.
     * Calcola un albero di copertura con radice la sorgente che copre tutto il
     * sottografo raggiungibile dalla sorgente. Per ogni nodo raggiungibile
     * calcola il numero minimo di passi per raggiungere la sorgente.
     * 
     * @param g
     *            un grafo.
     * @param s
     *            il nodo sorgente da cui iniziare la ricerca in ampiezza.
     */
    public void BFS(Graph<V, E> g, V s) throws IOException {
        // Come coda utilizziamo una semplice ArrayList
        ArrayList<V> q = new ArrayList<V>();
        // Per default tutti i nodi di un grafo sono bianchi
        // Inizializzo la sorgente
        g.setColor(s, Graph.COLOR_GREY);
        s.setDistance(0);
        s.setFather(null);
        // Metto la sorgente in coda
        q.add(s);
        while (!q.isEmpty()) {
            // Prendo l'elemento in testa alla coda che sarà già grigio
            V n = q.get(0);
            q.remove(0);
            // Trovo i nodi collegati a n
            Set<V> vicini = null;
            if (g.isDirected())
                vicini = g.successors(n);
            else
                vicini = g.neighbors(n);
            // Scorro tutti i vicini
            Iterator<V> iVicini = vicini.iterator();
            V vicino = null;
            while (iVicini.hasNext()) {
                vicino = iVicini.next();
                if (g.getColor(vicino) == Graph.COLOR_WHITE) {
                    // Il nodo vicino viene reso grigio, messo in coda,
                    // dichiarato come figlio di n nell'albero di copertura e
                    // gli viene settata la distanza
                    g.setColor(vicino, Graph.COLOR_GREY);
                    q.add(vicino);
                    vicino.setFather(n);
                    vicino.setDistance(n.getDistance() + 1);
                }
            }
            // Il nodo corrente n è stato completamente trattato
            g.setColor(n, Graph.COLOR_BLACK);
        }
    }
}
