package it.unicam.cs.tesei.graphs;

public class MyNodeBFS implements GenericBFSNode {
    private final java.lang.String id;

    private int distance;

    private MyNodeBFS father;

    /**
     * @param id
     */
    public MyNodeBFS(String id) {
        this.id = id;
        this.distance = 0;
        this.father = null;
    }

    /**
     * @return the distance
     */
    public int getDistance() {
        return distance;
    }

    /**
     * @param distance
     *            the distance to set
     */
    public void setDistance(int distance) {
        this.distance = distance;
    }

    /**
     * @return the father
     */
    public GenericBFSNode getFather() {
        return father;
    }

    /**
     * @param father
     *            the father to set
     */
    public void setFather(GenericBFSNode father) {
        if (father == null) {
            this.father = null;
            return;
        }
        if (father instanceof MyNodeBFS)
            this.father = (MyNodeBFS) father;
        else
            throw new IllegalArgumentException("Inserimento di"
                    + " un nodo padre non del tipo MyNodeBFS");
    }

    /**
     * @return the id
     */
    public java.lang.String getId() {
        return id;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof MyNodeBFS))
            return false;
        MyNodeBFS other = (MyNodeBFS) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" +
                "Nodo " + this.id + " - Distanza " + this.distance;
    }

}
