package it.unicam.cs.tesei.datasets;

/** Testa la classe DataSetPolimorfo */
public class DataSetPolimorfoTest {

    public static void main(String argv[]) {
        // Data set di conti
        DataSetPolimorfo bankData = new DataSetPolimorfo();
        bankData.add(new BankAccount(0));
        bankData.add(new BankAccount(10000));
        bankData.add(new BankAccount(1000));

        System.out.println("Media dei saldi: " + bankData.getAverage());
        Measurable max = bankData.getMaximum();
        System.out.println("Massimo saldo: " + max.getMeasure());

        // Data set di monete
        DataSetPolimorfo coinData = new DataSetPolimorfo();
        coinData.add(new Coin(0.25, "Quarter"));
        coinData.add(new Coin(0.10, "Dime"));
        coinData.add(new Coin(0.05, "Nickel"));

        System.out.println("Media dei valori: " + coinData.getAverage());
        max = coinData.getMaximum();
        System.out.println("Massimo valore: " + max.getMeasure());

        // Data set misto!
        DataSetPolimorfo mixData = new DataSetPolimorfo();
        mixData.add(new BankAccount(0.75));
        mixData.add(new Coin(0.01, "Penny"));
        mixData.add(new BankAccount(0.23));

        System.out.println("Media dei valori: " + mixData.getAverage());
        max = mixData.getMaximum();
        System.out.println("Massimo valore: " + max.getMeasure());

        // Conversioni di tipo
        BankAccount account = new BankAccount(10000);
        Measurable x = account; // Conversione legittima
        // x.deposit(100); Non si può fare!
        account.deposit(100); // Si può fare
        Coin dime = new Coin(0.10, "Dime");
        x = dime; // Legittimo
        // Cast esplicito con controllo instanceof
        if (x instanceof Coin) {// in questo caso sicuramente vero
            Coin c = (Coin) x;
            System.out.println("Moneta: " + c.getDescription());
        }

    }
}
