package it.unicam.cs.tesei.equations;

/**
 * Equazione di secondo grado non modificabile
 * 
 * @author Luca Tesei
 * @version ASD-L
 */
public class EquazioneDiSecondoGrado {

    private final double a;

    private final double b;

    private final double c;

    private final double delta;

    /**
     * Costruisce una equazione con i tre parametri
     * 
     * @param a
     *            il parametro a deve essere diverso da zero
     */
    public EquazioneDiSecondoGrado(double a, double b, double c) {
        if (a != 0)
            this.a = a;
        else
            throw new IllegalArgumentException(
                    "Parametro a uguale a zero, l'equazione non è di secondo grado");
        this.b = b;
        this.c = c;
        this.delta = b * b - 4 * a * c;
    }

    /**
     * Restituisce il parametro a
     */
    public double getA() {
        return a;
    }

    /**
     * Restituisce il parametro b
     */
    public double getB() {
        return b;
    }

    /**
     * Restituisce il parametro c
     */
    public double getC() {
        return c;
    }

    /**
     * Restituisce la prima soluzione. Nel caso di nessuna soluzione restituisce
     * la costante Double.NaN
     */
    public double getFirstSolution() {
        if (delta < 0)
            return Double.NaN;
        else if (delta == 0)
            return -b / (2 * a);
        else
            // caso delta > 0
            return (-b + Math.sqrt(delta)) / (2 * a);
    }

    /**
     * Restituisce la seconda soluzione. Nel caso di nessuna soluzione
     * restituisce la costante Double.NaN
     */
    public double getSecondSolution() {
        if (delta < 0)
            return Double.NaN;
        else if (delta == 0)
            return -b / (2 * a);
        else
            // caso delta > 0
            return (-b - Math.sqrt(delta)) / (2 * a);
    }

}
