package it.unicam.cs.tesei.equations;

import java.io.*;

/**
 * Realizzazione procedurale NON Object Oriented di un programma che calcola le
 * soluzioni di una equazione di secondo grado.
 * 
 * @author luca
 *
 */
public class EquazioneDiSecondoGradoProcedurale {

    /**
     * Tutto il calcolo si svolge qui
     * 
     * @param args
     */
    public static void main(String[] args) {
        double a, b, c, delta, sol1, sol2;
        BufferedReader console = new BufferedReader(new InputStreamReader(
                System.in));
        System.out.println("Inserire il parametro a");
        a = readDouble(console);
        while (a == 0) {
            System.out
                    .println("Il parametro a non può essere zero! Inserire il parametro a");
            a = readDouble(console);
        }
        System.out.println("Inserire il parametro b");
        b = readDouble(console);
        System.out.println("Inserire il parametro c");
        c = readDouble(console);
        delta = b * b - 4 * a * c;
        if (delta < 0) {
            System.out.println("L'equazione non ha soluzioni reali");
            return;
        }
        if (delta == 0) {
            sol1 = -b / 2 * a;
            System.out.println("Soluzioni reali coincidenti uguali a " + sol1);
            return;
        }
        sol1 = (-b + Math.sqrt(delta)) / 2 * a;
        sol2 = (-b - Math.sqrt(delta)) / 2 * a;
        System.out.println("Soluzione 1 = " + sol1);
        System.out.println("Soluzione 2 = " + sol2);
        return;
    }

    /**
     * Funzione ausiliaria per leggere dallo standard input un numero floating
     * point
     * 
     * @param br
     * @return
     */
    public static double readDouble(BufferedReader br) {
        boolean valoreLetto = false;
        boolean valoreDoubleLetto = false;
        String line = null;
        double value = Double.NaN;
        do {
            do {
                try {
                    line = br.readLine(); // Possibile Eccezione di I/O
                    valoreLetto = true;
                } catch (IOException e) {
                    System.out.println("Errore di Input Output, Riprova");
                }
            } while (!valoreLetto);
            try {
                value = Double.parseDouble(line); // Possibile Eccezione!
                valoreDoubleLetto = true;
            } catch (NumberFormatException e) {
                System.out
                        .println("Inserire un numero nel formato floating point");
            }
        } while (!valoreDoubleLetto);
        return value;
    }

}
