/**
 * 
 */
package it.unicam.cs.tesei.graphs;

import java.util.Set;

/**
 * Grafo generico in cui i nodi contengono oggetti di una generica classe
 * 
 * @author Luca Tesei
 *
 */
public interface Graph<E> {
    /**
     * Aggiunge un nodo a questo grafo.
     * 
     * @param newNode l'oggetto da associare al nodo
     * @return true se il nodo è stato aggiunto, false se era già presente
     */
    public boolean addNode(E newNode);
    /**
     * Rimuove un nodo in questo grafo e tutti gli archi che incidono su di esso.
     * 
     * @param node
     * @return true se il nodo è stato rimosso, false se il nodo non è presente
     */
    public boolean removeNode(E node);
    /**
     * Aggiunge un arco a questo grafo. 
     * @param node1 nodo dell'arco, nodo sorgente in caso di grafi diretti
     * @param node2 l'altro nodo dell'arco, nodo destinazione in caso di grafi diretti
     * @return true se l'arco è stato aggiunto, false se era già presente
     */
    public boolean addEdge(E node1, E node2);
    /**
     * Rimuove un arco di questo grafo.
     * @param node1
     * @param node2
     * @return true se l'arco è stato rimosso, false se non era presente
     */
    public boolean removeEdge(E node1, E node2);
    /**
     * Controlla se due nodi sono connessi in questo grafo
     * 
     * @param node1
     * @param node2
     * 
     * @return true se node1 e node2 sono connessi
     */
    public boolean areConnected(E node1, E node2);
    
    /**
     * Restituisce tutti i nodi a cui un certo nodo è connesso.
     * @param node
     * @return
     */
    public Set<E> adjacentNodes(E node);
    /**
     * Controlla se il grafo è vuoto.
     * @return
     */
    public boolean isEmpty();
    
    // Interface da espandere in futuro con altri metodi
    

}
