/**
 * 
 */
package it.unicam.cs.tesei.hash;

/**
 * Contratto che definisce le operazioni di una tabella hash a dimensione
 * prefissata.
 * 
 * @author luca
 *
 */
public interface Hash<E> {

    /**
     * Inserisce un elemento della classe E nella tabella hash.
     * 
     * @param o
     *            l'elemento da inserire
     * @return true se l'elemento è stato inserito, false se l'elemento era già
     *         presente e quindi non è stato inserito ulteriormente. La presenza
     *         viene testata utilizzando il metodo <code>equals()</code> della
     *         classe E che si suppone sia stato ridefinito in maniera
     *         opportuna.
     */
    public boolean insert(E o);

    /**
     * Cerca un elemento in questa tabella hash.
     * 
     * @param o
     *            elemento da cercare
     * @return true se l'elemento è presente nella tabella hashe, false se
     *         l'elemento non è presente. La presenza viene testata utilizzando
     *         il metodo <code>equals()</code> della classe E che si suppone sia
     *         stato ridefinito in maniera opportuna.
     */
    public boolean search(E o);

    /**
     * Rimuove un oggetto dalla tabella hash.
     * 
     * @param o
     *            elemento da rimuovere
     * @return true se l'elemento era presente e quindi è stato rimosso, false
     *         se l'elemento non era presente e quindi non è stato rimosso. La
     *         presenza viene testata utilizzando il metodo
     *         <code>equals()</code> della classe E che si suppone sia stato
     *         ridefinito in maniera opportuna.
     * 
     */
    public boolean remove(E o);

    /**
     * Restituisce la dimensione (statica) di questa tabella hash.
     * @return la dimensione di questa tabella hash.
     */
    public int getDimension();

}
