package it.unicam.cs.tesei.hash;

import java.util.ArrayList;
import java.util.List;

/**
 * Tabella hash statica.
 * 
 * @author Luca Tesei
 *
 * @param <E>
 *            Classe degli elementi da inserire nella tabella. Si suppone che
 *            nella classe siano stati ridefiniti in maniera opportuna i metodi
 *            equals e hashcode.
 */
public class MyHash<E> implements Hash<E> {
    // Array che contiene la hash table
    private List<List<E>> h;

    /**
     * Costruisce una tabella hash di capacità fissata. Questa classe non adatta
     * automaticamente la dimensione della tabella in caso di fattore di
     * caricamento alto.
     * 
     * @param initialCapacity
     *            capacità della tabella.
     */
    public MyHash(int initialCapacity) {
        this.h = new ArrayList<List<E>>();
        for (int i = 0; i < initialCapacity; i++)
            this.h.add(null);
    }

    // Funzione di hashing utilizzata dalla tabella hash
    private int hash(int key) {
        return key % this.h.size();
    }

    @Override
    public boolean insert(E o) {
        if (o == null) {
            throw new NullPointerException(
                    "Inserimento di elemento nullo nella hash table");
        }
        // Cerco la posizione di questo elemento
        int key = hash(o.hashCode());
        // Controllo se la posizione è libera
        if (h.get(key) == null) {
            // Posizione libera
            // Creo una lista e inserisco l'elemento
            h.set(key, new ArrayList<E>());
            h.get(key).add(o);
            return true;
        } else {
            // La posizione è già occupata
            // Controllo se l'elemento è già presente nel bucket
            if (h.get(key).contains(o)) {
                // L'elemento è già presente
                return false;
            } else {
                // Collisione, elemento da inserire nel bucket
                h.get(key).add(o);
                return true;
            }
        }
    }

    @Override
    public boolean search(E o) {
        if (o == null) {
            throw new NullPointerException(
                    "Ricerca di elemento nullo nella hash table");
        }
        // Cerco la posizione di questo elemento
        int key = hash(o.hashCode());
        // Controllo la posizione
        if (h.get(key) == null)
            return false;
        else {
            // Il bucket non è vuoto
            // Controllo se l'elemento è nel bucket oppure no
            return h.get(key).contains(o);
        }
    }

    @Override
    public boolean remove(E o) {
        if (o == null) {
            throw new NullPointerException(
                    "Rimozione di elemento nullo nella hash table");
        }
        // Cerco se l'elemento è presente
        if (!search(o))
            // L'elemento non è presente
            return false;
        else {
            // L'elemento è presente
            // Cerco la posizione di questo elemento
            int key = hash(o.hashCode());
            h.get(key).remove(o);
            return true;
        }
    }

    @Override
    public int getDimension() {
        return h.size();
    }

}
