package it.unicam.cs.tesei.mylist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/**
 * Implementazione con Linked List (doppio link next e previous)
 * dell'interfaccia List<E>. ATTENZIONE: Codice da completare, è presente solo
 * il codice sviluppato durante le ore di lezione.
 * 
 * Questa classe <b>non</b> accetta l'inserimento di elementi di tipo
 * <code>null</code>.
 * 
 * @author Luca Tesei 24/03/2016
 *
 * @param <E>
 *            Tipo qualsiasi di oggetti che possono essere aggiunti a questa
 *            lista
 */
public class MyList<E> implements List<E> {

    private MyListEl first;

    private MyListEl last;

    private int length;

    public MyList() {
        this.first = null;
        this.length = 0;
        this.last = null;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        if (this.length == 0)
            return true;
        else
            return false;
    }

    @Override
    public boolean contains(Object o) {
        if (firstPointerOf(o) != null)
            return true;
        else
            return false;
    }

    /*
     * Cerca il primo elemento che sia equals ad o.
     * 
     * @return il puntatore al primo elemento della lista che sia equals ad o
     * oppure null se la lista non contiene nessun elemento equals ad o
     */
    private MyListEl firstPointerOf(Object o) {
        // Flag per la ricerca lineare incerta
        boolean trovato = false;
        // Puntatore per scorrimento lista
        MyListEl p = this.first;
        // Ciclo di scorrimento
        while (p != null && !trovato)
            if (p.el.equals(o))
                trovato = true;
            else
                p = p.next;
        if (trovato)
            return p;
        else
            return null;
    }

    @Override
    public Iterator<E> iterator() {
        return new MyListIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.length];
        MyListEl p = this.first;
        int i = 0;
        while (p != null) {
            a[i] = p.el;
            p = p.next;
            i++;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean add(E e) {
        if (e == null)
            throw new NullPointerException(
                    "Null references can not be added to this list");
        // L'elemento da aggiungere non è nullo
        MyListEl nuovo;
        // Nel caso di lista vuota, inizializzo la lista
        if (this.length == 0) {
            nuovo = new MyListEl(e, null, null); // Crea l'ultimo elemento della
            // lista
            this.first = nuovo;
            this.last = nuovo;
            this.length = 1;
            return true;
        }
        // Nel caso di lista non vuota, inserisco l'elemento in fondo
        nuovo = new MyListEl(e, null, this.last); // Crea l'ultimo elemento
                                                  // della
        // lista
        this.last.next = nuovo; // Copio il riferimento al nuovo oggetto nel
                                // next dell'ex ultimo elemento
        this.last = nuovo; // Aggiorno il riferimento all'ultimo elemento della
                           // lista
        this.length++; // Aggiorno la lunghezza della lista
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null)
            throw new NullPointerException(
                    "This list does not accept null references");
        if (this.length == 0)
            return false;
        // La lista non è vuota: cerco il primo elemento della lista che è
        // equals a o
        MyListEl toBeRemoved = firstPointerOf(o);
        if (toBeRemoved == null)
            return false; // L'elemento non è presente e quindi non rimuovo
                          // niente
        // Controllo se l'elemento da rimuovere è il primo della lista
        if (this.first == toBeRemoved) {
            if (this.last == toBeRemoved) {
                // l'elemento da rimuovere è anche l'ultimo, quindi la lista
                // ridiventa vuota
                this.first = null;
                this.last = null;
                this.length = 0;
                return true;
            }
            // l'elemento da rimuovere è il primo e ha elementi successivi
            this.first = toBeRemoved.next;
            this.length--;
            return true;
        }
        // L'elemento da rimuovere non è il primo della lista
        toBeRemoved.previous.next = toBeRemoved.next;
        this.length--;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void clear() {
        // TODO Auto-generated method stub

    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.length)
            throw new IndexOutOfBoundsException(
                    "Richiesto elemento all'indice " + index
                            + " che non è un indice valido di questa lista");
        // L'indice index è valido
        // Cerco l'elemento nella lista
        MyListEl p = this.first;
        int i = 0; // sarà l'indice dell'elemento trovato
        while (i < index) {
            p = p.next; // vado avanti al prossimo elemento
            i++; // incremento l'indice
        }
        return p.el;
    }

    @Override
    public E set(int index, E element) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void add(int index, E element) {
        // TODO Auto-generated method stub

    }

    @Override
    public E remove(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null)
            throw new NullPointerException(
                    "This list does not accept null references");
        // Cerco l'elemento nella lista
        boolean trovato = false;
        MyListEl p = this.first;
        int i = 0; // sarà l'indice dell'elemento trovato
        while (p != null && !trovato)
            if (p.el.equals(o))
                trovato = true;
            else {
                p = p.next; // vado avanti al prossimo elemento
                i++; // incremento l'indice
            }
        if (trovato)
            return i;
        else
            return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public ListIterator<E> listIterator() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        // TODO Auto-generated method stub
        return null;
    }

    /*
     * Classe privata che realizza la lista con puntatori. Un oggetto della
     * classe MyListEl contiene un elemento della lista.
     */
    private class MyListEl {

        private E el;

        private MyListEl next;

        private MyListEl previous;

        /**
         * @param el
         * @param next
         */
        public MyListEl(E el, MyList<E>.MyListEl next) {
            this.el = el;
            this.next = next;
            this.previous = null;
        }

        /**
         * @param el
         * @param next
         * @param previous
         */
        public MyListEl(E el, MyList<E>.MyListEl next,
                MyList<E>.MyListEl previous) {
            this.el = el;
            this.next = next;
            this.previous = previous;
        }

    }

    private class MyListIterator implements Iterator<E> {
        // La list che questo iteratore sta scorrendo
        private MyList<E> list;

        // L'elemento corrente
        private MyListEl current;

        // L'indice dell'elemento corrente
        private int currentIndex;

        // Se true indica che l'iteratore è immediatamente prima l'elemento
        // corrente, altrimenti immediatamente dopo
        private boolean before;

        // Se true indica che è stato effettuato un remove sull'elemento
        // corrente
        private boolean removeDone;

        public MyListIterator(MyList<E> list) {
            this.list = list;
            if (list.isEmpty()) {
                current = null;
                currentIndex = -1;
                before = false;
                removeDone = true;
            } else {
                current = list.first;
                currentIndex = 0;
                before = true;
                removeDone = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (current == null) // la lista è vuota
                return false;
            // la lista non è vuota
            if (before)
                return true;
            else if (current.next != null)
                return true;
            else
                return false;
        }

        @Override
        public E next() {
            if (!this.hasNext())
                throw new NoSuchElementException(
                        "Richiesto elemento non esistente nell'iterazione");
            // C'è un next
            if (this.before) {
                this.before = false;
                this.removeDone = false; // resetto questo flag visto il nuovo
                                         // next
                return this.current.el;
            } else if (this.current.next == null) // Sono all'ultimo elemento
                throw new NoSuchElementException(
                        "Richiesto elemento non esistente nell'iterazione");
            else { // restituisco il prossimo elemento facendo scorrere current
                this.current = this.current.next;
                this.currentIndex++;
                this.before = false;
                this.removeDone = false; // resetto questo flag visto il nuovo
                                         // next
                return this.current.el;
            }
        }

        @Override
        public void remove() {
            if (removeDone)
                return;
            // Posso fare il remove solo se before è falso
            if (before)
                return;
            // Controllo se sto cancellando l'ultimo elemento
            if (current == list.last)
                // Controllo se sono anche il primo
                if (current == list.first) {
                    // Rimuovo l'elemento dalla lista e mi posiziono sulla lista
                    // vuota
                    this.list.remove(currentIndex);
                    this.current = null;
                    this.currentIndex = -1;
                    this.before = false;
                    this.removeDone = true;
                } else { // sto cancellando l'ultimo elemento, ma non sono sul
                         // primo
                    this.list.remove(currentIndex);
                    this.current = this.current.previous;
                    this.currentIndex--;
                    this.before = false;
                    this.removeDone = true;
                }
            else { // non sto cancellando l'ultimo elemento
                this.list.remove(this.currentIndex);
                this.current = this.current.next;
                // this.currentIndex rimane lo stesso!! per compattamento della
                // lista
                this.before = true;
                this.removeDone = true;
            }
        }
    }

}
