package it.unicam.cs.tesei.sorting;

import java.util.List;

public class InsertionSort<E extends Comparable<E>> implements
        SortingAlgorithm<E> {

    @Override
    public SortingAlgorithmResult<E> sort(List<E> l) {
        // numero di confronti
        int countCompare = 0;
        int n = l.size();
        for (int i = 1; i < n; i++) {
            E currentValue = l.get(i);
            // Ricerca lineare incerta all'indietro del primo elemento della
            // lista che è minore o uguale del valore corrente
            boolean trovato = false;
            int j = i - 1;
            while (j >= 0 && !trovato) {
                countCompare++;
                if (currentValue.compareTo(l.get(j)) >= 0)
                    trovato = true;
                else
                    j--;
            }
            if (trovato) {
                // Bisogna inserire l'elemento in posizione i nella posizione
                // j+1 e far scorrere tutti gli elementi verso destra
                // PRIMA tolgo l'elemento in posizione i
                l.remove(i);
                // POI inserisco lo stesso elemento in posizione j+1
                l.add(j + 1, currentValue);
                // Se avessi fatto prima l'inserimento, avrei poi eliminato
                // l'elemento sbagliato
            } else {
                // Bisogna inserire l'elemento in posizione i nella posizione
                // 0 e far scorrere tutti gli elementi verso destra
                // PRIMA tolgo l'elemento in posizione i
                l.remove(i);
                // POI inserisco lo stesso elemento in posizione 0
                l.add(0, currentValue);
                // Se avessi fatto prima l'inserimento, avrei poi eliminato
                // l'elemento sbagliato
            }  
            // end for
        }
     // Costruisco il risultato
        return new SortingAlgorithmResult<E>(l, countCompare);
    }

}
