package it.unicam.cs.tesei.sorting;

import java.util.ArrayList;
import java.util.List;

/**
 * Implementazione del Merge sort che fa delle copie delle due sottoliste nella
 * fase divide e le passa alle chiamate ricorsive. Successivamente il merge
 * legge dalle due sottoliste ottenute come risultato e scrive sulla lista
 * principale, che viene ritornata. In questo modo non si fa uso di indici per
 * indicare le porzioni della sequenza interessate dalla chiamata ricorsiva.
 * 
 * @author Luca Tesei
 *
 * @param <E> Classe degli elementi da ordinare
 */
public class MergeSort<E extends Comparable<E>> implements SortingAlgorithm<E> {

    @Override
    public SortingAlgorithmResult<E> sort(List<E> l) {
        // Caso base della ricorsione
        if (l.size() <= 1)
            return new SortingAlgorithmResult<E>(l, 0);
        // Caso ricorsivo
        // Divido la sequenza in due sottosequenze, creando delle copie
        List<E> primaParte = new ArrayList<E>();
        List<E> secondaParte = new ArrayList<E>();
        int i; // indice per scorrere la lista principale
        // Copio la prima parte di l su primaParte
        for (i = 0; i <= (l.size() / 2 - 1); i++)
            primaParte.add(l.get(i));
        // Copio la seconda parte di l su secondaParte
        while (i < l.size()) {
            secondaParte.add(l.get(i));
            i++;
        }
        // Chiamata Ricorsiva sulla prima parte
        SortingAlgorithmResult<E> risultatoPrimaParte = this.sort(primaParte);
        // Chiamata Ricorsiva sulla seconda parte
        SortingAlgorithmResult<E> risultatoSecondaParte = this
                .sort(secondaParte);
        // Restituisco il merge
        return this.merge(
                risultatoPrimaParte.getL(),
                risultatoSecondaParte.getL(),
                risultatoPrimaParte.getCountCompare()
                        + risultatoSecondaParte.getCountCompare(), l);
    }

    /**
     * Metodo privato per fare il merge di due liste.
     * 
     * @param listaInput1
     *            prima lista ordinata
     * @param listaInput2
     *            seconda lista ordinata
     * @param countCompareInput
     *            numero di confronti già effettuati
     * @param listaOutput
     *            lista su cui scrivere la lista intera ordinata risultante dal
     *            merge
     * @return un oggetto che contiene la lista intera ordinata risultante dal
     *         merge e il numero di confronti totali effettuati dal merge più
     *         quelli precedentemente effettuati
     */
    private SortingAlgorithmResult<E> merge(List<E> listaInput1,
            List<E> listaInput2, int countCompareInput, List<E> listaOutput) {
        /*
         * Casi semplici in cui basta attaccare le due liste, evito di fare il
         * merge
         */
        // Primo caso semplice, un solo compare in più
        if (listaInput1.get(listaInput1.size() - 1).compareTo(
                listaInput2.get(0)) <= 0) {
            // listaInput1 concatenata con listaInput2 è il risultato
            listaOutput.clear();
            listaOutput.addAll(listaInput1);
            listaOutput.addAll(listaInput2);
            return new SortingAlgorithmResult<E>(listaOutput,
                    countCompareInput + 1);
        }
        // Secondo caso semplice, due compare in più
        if (listaInput2.get(listaInput2.size() - 1).compareTo(
                listaInput1.get(0)) <= 0) {
            // listaInput2 concatenata con listaInput1 è il risultato
            listaOutput.clear();
            listaOutput.addAll(listaInput2);
            listaOutput.addAll(listaInput1);
            return new SortingAlgorithmResult<E>(listaOutput,
                    countCompareInput + 2);
        }
        // Casi di effettivo merge
        int j = 0; // indice per listaOutput
        int i1 = 0; // indice per listaInput1
        int i2 = 0; // indice per listaInput2
        while (i1 < listaInput1.size() && i2 < listaInput2.size()) {
            countCompareInput++; // conto il confronto seguente
            if (listaInput1.get(i1).compareTo(listaInput2.get(i2)) < 0) {
                // scorre listaInput1
                listaOutput.set(j, listaInput1.get(i1));
                j++;
                i1++;
            } else {
                // scorre listaInput2
                listaOutput.set(j, listaInput2.get(i2));
                j++;
                i2++;
            }
            // end while
        }
        // Aggiungo l'ultimo pezzo di listaInput1 o listaInput2
        if (i1 == listaInput1.size()) {
            // è terminata per prima listaInput1 e quindi aggiungo tutta
            // listaInput2
            while (i2 < listaInput2.size()) {
                listaOutput.set(j, listaInput2.get(i2));
                j++;
                i2++;
            }
        } else {
            // è terminata per prima listaInput2 e quindi aggiungo tutta
            // listaInput1
            while (i1 < listaInput1.size()) {
                listaOutput.set(j, listaInput1.get(i1));
                j++;
                i1++;
            }
        }
        // Costruisco il risultato e ritorno
        return new SortingAlgorithmResult<E>(listaOutput, countCompareInput);
    }

    @Override
    public String getName() {
        return "MergeSort";
    }

}
