/**
 * 
 */
package it.unicam.cs.tesei.sorting;

import java.util.ArrayList;
import java.util.List;

/**
 * Implementazione ricorsiva del Merge Sort che fa uso della stessa lista l
 * lungo le chiamate ricorsive gestendo la divisione in parti tramite indici e
 * creando una copia di appoggio solo per il merge.
 * 
 * @author Luca Tesei
 *
 */
public class MergeSortIndex<E extends Comparable<E>> implements
        SortingAlgorithm<E> {

    @Override
    public SortingAlgorithmResult<E> sort(List<E> l) {
        if (l.size() <= 1)
            return new SortingAlgorithmResult<E>(l, 0);
        // Chiama il metodo ricorsivo
        return mergeSort(l, 0, l.size());
    }

    /**
     * Metodo ricorsivo che realizza il Merge Sort.
     * 
     * @param l
     *            lista di elementi da ordinare
     * @param start
     *            indice di partenza della sottolista da considerare (incluso)
     * @param stop
     *            indice di arrivo della sottolista da considerare (escluso)
     * @return un oggetto che comprende la lista l data in input con la parte da
     *         considerare ordinata e il numero di confronti effettuati
     */
    private SortingAlgorithmResult<E> mergeSort(List<E> l, int start, int stop) {
        // System.out.println("mergeSort: start " + start + " stop " + stop);
        // Caso base della ricorsione
        if (stop - start <= 1)
            return new SortingAlgorithmResult<E>(l, 0);
        // Caso ricorsivo
        // Determina il punto di divisione in due parti della sequenza
        int mid = start + ((stop - start) / 2);
        // Chiamata sulla prima parte
        SortingAlgorithmResult<E> risultatoPrimaParte = mergeSort(l, start, mid);
        int countCompare = risultatoPrimaParte.getCountCompare();
        // Chiamata sulla seconda parte
        SortingAlgorithmResult<E> risultatoSecondaParte = mergeSort(l, mid,
                stop);
        countCompare += risultatoSecondaParte.getCountCompare();
        // Esegue il merge
        countCompare += merge(l, start, mid, stop);
        return new SortingAlgorithmResult<E>(l, countCompare);
    }

    private int merge(List<E> l, int start, int mid, int stop) {
        /*
         * Casi semplici in cui basta attaccare le due liste, evito di fare il
         * merge
         */
        // Primo caso semplice in cui la parte da considerare è già ordinata
        if (l.get(mid - 1).compareTo(l.get(mid)) <= 0)
            return 1;
        // Secondo caso semplice in cui basta scambiare le due parti
        if (l.get(stop - 1).compareTo(l.get(start)) <= 0) {
            // salvo la prima parte della lista
            List<E> a = new ArrayList<E>();
            for (int p = start; p < mid; p++)
                a.add(l.get(p));
            // Copio la seconda parte sulla prima
            int q;
            for (q = start; q < start + (stop - mid); q++)
                l.set(q, l.get(q + a.size()));
            // Copio la prima parte in fondo
            for (int r = 0; r < a.size(); r++) {
                l.set(q, a.get(r));
                q++;
            }
            return 2;
        }
        // Casi di merge effettivo
        int countCompare = 0;
        int i = start; // indice per la prima parte
        int j = mid; // indice per la seconda parte
        List<E> a = new ArrayList<E>(); // Lista di appoggio
        while (i < mid && j < stop) {
            // conto il prossimo confronto
            countCompare++;
            if (l.get(i).compareTo(l.get(j)) < 0) {
                // Scorre la prima parte
                a.add(l.get(i));
                i++;
            } else {
                // Scorre la seconda parte
                a.add(l.get(j));
                j++;
            }
        }
        // Aggiungo il pezzo rimasto
        if (i == mid) {
            // è terminata prima la prima parte, quindi aggiungo tutta la
            // seconda parte rimasta
            while (j < stop) {
                a.add(l.get(j));
                j++;
            }
        } else {
            // è terminata prima la sconda parte, quindi aggiungo tutta la prima
            // parte rimasta
            while (i < mid) {
                a.add(l.get(i));
                i++;
            }
        }
        // Copio la sequenza ordinata sulla lista originale l
        for (int k = 0; k < a.size(); k++)
            l.set(start + k, a.get(k));
        return countCompare;
    }

    @Override
    public String getName() {
        return "MergeSortIndex";
    }
}
