/**
 * 
 */
package it.unicam.cs.tesei.sorting;

import java.util.List;

/**
 * Implementazione del Bubble Sort su generici elementi. Versione base con un
 * numero fisso di confronti che dipende dalla lunghezza della sequenza di
 * elementi.
 * 
 * @author Luca Tesei
 * @param <E>
 *            Tipo degli elementi. La classe deve fornire un ordinamento totale
 *            naturale tra gli elementi tramite il metodo compareTo()
 *
 */
public class SimpleBubbleSort<E extends Comparable<E>> implements
        SortingAlgorithm<E> {

    @Override
    public SortingAlgorithmResult<E> sort(List<E> l) {
        // numero di confronti
        int countCompare = 0;
        int n = l.size();
        // ciclo esterno per lo scorrimento dei primi n-1 elementi
        for (int i = 0; i < n - 1; i++)
            // ciclo interno per lo scorrimento degli elementi da i+1 a n
            for (int j = i + 1; j < n; j++) {
                // confronto da contare
                countCompare++;
                // if elemento in posizione i > elemento in posizione j
                if (l.get(i).compareTo(l.get(j)) > 0) {
                    // Scambio l'elemento in posizione i con l'elemento in
                    // posizione j
                    E temp = l.get(i);
                    l.set(i, l.get(j));
                    l.set(j, temp);
                }
            }
        // Costruisco il risultato
        return new SortingAlgorithmResult<E>(l, countCompare);
    }

}
