/**
 * 
 */
package it.unicam.cs.tesei.sorting;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Classe di test per algoritmi di ordinamento generici.
 * 
 * @author Luca Tesei
 *
 */
public class SortingAlgorithmTester {

    /**
     * Tester.
     * 
     * @param args parametri da linea di comando. Non sono previsti.
     */
    public static void main(String[] args) {
        // Creo la lista per inserire gli elementi
        List<Integer> l = new ArrayList<>();
        // Creo un generatore di numeri casuali da inserire nella sequenza
        Random randomGenerator = new Random();
        System.out.println("Lista di numeri da ordinare:");
        for (int i = 0; i < 20; i++) {
            int v = randomGenerator.nextInt(50);
            System.out.print(v + " ");
            // Inserisco nella lista
            l.add(new Integer(v));
        }
        System.out.print("\n");
        // Creo un algoritmo di ordinamento usando l'implementazione Simple
        // Bubble Sort
        SortingAlgorithm<Integer> bubble = new SimpleBubbleSort<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        long startTime = System.currentTimeMillis();
        long startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        SortingAlgorithmResult<Integer> risultato = bubble.sort(l);
        // Registro il tempo impiegato dall'algoritmo
        long elapsedTimeNano = System.nanoTime() - startTimeNano;
        long elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata:");
        for (int i = 0; i < risultato.getL().size(); i++)
            System.out.print(risultato.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out.println("Numero di confronti effettuati = "
                + risultato.getCountCompare());
        System.out.println("Tempo impiegato: " + elapsedTimeNano
                + " in nanosecondi");
        System.out.println("Tempo impiegato: " + elapsedTime
                + " in millisecondi");

    }
}
