/**
 * 
 */
package it.unicam.cs.tesei.sorting;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Classe di test per algoritmi di ordinamento generici.
 * 
 * @author Luca Tesei
 *
 */
public class SortingAlgorithmTester {

    /**
     * Tester.
     * 
     * @param args
     *            parametri da linea di comando. Non sono previsti.
     */
    public static void main(String[] args) {
        // Creo la lista per inserire gli elementi
        List<Integer> l = new ArrayList<>();
        // Creo un generatore di numeri casuali da inserire nella sequenza
        Random randomGenerator = new Random();
        System.out.println("Lista di numeri da ordinare:");
        for (int i = 0; i < 1000; i++) {
            int v = randomGenerator.nextInt(800);
            System.out.print(v + " ");
            // Inserisco nella lista
            l.add(new Integer(v));
        }
        System.out.println("\n");

        // Creo copie della lista non ordinata da passare agli altri
        // algoritmi
        List<Integer> lCopiaInsertion = new ArrayList<>();
        lCopiaInsertion.addAll(l);
        List<Integer> lCopiaMerge = new ArrayList<>();
        lCopiaMerge.addAll(l);
        List<Integer> lCopiaMergeIndex = new ArrayList<>();
        lCopiaMergeIndex.addAll(l);
        List<Integer> lCopiaHeapSort = new ArrayList<>();
        lCopiaHeapSort.addAll(l);

        // Creo un algoritmo di ordinamento usando l'implementazione del Simple
        // Bubble Sort
        SortingAlgorithm<Integer> bubble = new SimpleBubbleSort<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        long startTime = System.currentTimeMillis();
        long startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        SortingAlgorithmResult<Integer> risultatoBubble = bubble.sort(l);
        // Registro il tempo impiegato dall'algoritmo
        long elapsedTimeNano = System.nanoTime() - startTimeNano;
        long elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata dal Simple Bubble Sort:");
        for (int i = 0; i < risultatoBubble.getL().size(); i++)
            System.out.print(risultatoBubble.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out
                .println("Numero di confronti effettuati dal Simple Bubble Sort = "
                        + risultatoBubble.getCountCompare());
        System.out.println("Tempo impiegato dal Simple Bubble Sort: "
                + elapsedTimeNano + " in nanosecondi");
        System.out.println("Tempo impiegato dal Simple Bubble Sort: "
                + elapsedTime + " in millisecondi\n");

        // Creo un algoritmo di ordinamento usando l'implementazione
        // dell'Insertion Sort
        SortingAlgorithm<Integer> insertion = new InsertionSort<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        startTime = System.currentTimeMillis();
        startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        // SortingAlgorithmResult<Integer> risultato = bubble.sort(l);
        SortingAlgorithmResult<Integer> risultatoInsertion = insertion
                .sort(lCopiaInsertion);
        // Registro il tempo impiegato dall'algoritmo
        elapsedTimeNano = System.nanoTime() - startTimeNano;
        elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata dall' Insertion Sort:");
        for (int i = 0; i < risultatoInsertion.getL().size(); i++)
            System.out.print(risultatoInsertion.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out
                .println("Numero di confronti effettuati dall'Insertion Sort = "
                        + risultatoInsertion.getCountCompare());
        System.out.println("Tempo impiegato dall'Insertion Sort: "
                + elapsedTimeNano + " in nanosecondi");
        System.out.println("Tempo impiegato dall'Insertion Sort: "
                + elapsedTime + " in millisecondi\n");

        // Creo un algoritmo di ordinamento usando l'implementazione del Merge
        // Sort
        SortingAlgorithm<Integer> merge = new MergeSort<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        startTime = System.currentTimeMillis();
        startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        SortingAlgorithmResult<Integer> risultatoMerge = merge
                .sort(lCopiaMerge);
        // Registro il tempo impiegato dall'algoritmo
        elapsedTimeNano = System.nanoTime() - startTimeNano;
        elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata dal Merge Sort:");
        for (int i = 0; i < risultatoMerge.getL().size(); i++)
            System.out.print(risultatoMerge.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out.println("Numero di confronti effettuati dal Merge Sort = "
                + risultatoMerge.getCountCompare());
        System.out.println("Tempo impiegato dal Merge Sort: " + elapsedTimeNano
                + " in nanosecondi");
        System.out.println("Tempo impiegato dal Merge Sort: " + elapsedTime
                + " in millisecondi\n");
        
        // Creo un algoritmo di ordinamento usando l'implementazione del Merge
        // Sort con indici
        SortingAlgorithm<Integer> mergeIndex = new MergeSortIndex<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        startTime = System.currentTimeMillis();
        startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        SortingAlgorithmResult<Integer> risultatoMergeIndex = mergeIndex
                .sort(lCopiaMergeIndex);
        // Registro il tempo impiegato dall'algoritmo
        elapsedTimeNano = System.nanoTime() - startTimeNano;
        elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata dal Merge Sort con indici:");
        for (int i = 0; i < risultatoMergeIndex.getL().size(); i++)
            System.out.print(risultatoMergeIndex.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out.println("Numero di confronti effettuati dal Merge Sort con indici= "
                + risultatoMergeIndex.getCountCompare());
        System.out.println("Tempo impiegato dal Merge Sort con indici: " + elapsedTimeNano
                + " in nanosecondi");
        System.out.println("Tempo impiegato dal Merge Sort con indici: " + elapsedTime
                + " in millisecondi\n");
        
        
     // Creo un algoritmo di ordinamento usando l'implementazione del Merge
        // Sort con indici
        SortingAlgorithm<Integer> heapSort = new HeapSort<Integer>();
        // Guardo il tempo corrente in millisecondi e nanosecondi
        startTime = System.currentTimeMillis();
        startTimeNano = System.nanoTime();
        // Chiamo l'algoritmo di ordinamento
        SortingAlgorithmResult<Integer> risultatoHeapSort = heapSort
                .sort(lCopiaHeapSort);
        // Registro il tempo impiegato dall'algoritmo
        elapsedTimeNano = System.nanoTime() - startTimeNano;
        elapsedTime = System.currentTimeMillis() - startTime;
        // Report dei risultati
        System.out.println("Lista di numeri ordinata dallo Heap Sort:");
        for (int i = 0; i < risultatoHeapSort.getL().size(); i++)
            System.out.print(risultatoHeapSort.getL().get(i).intValue() + " ");
        System.out.print("\n");
        System.out.println("Numero di confronti effettuati dallo Heap Sort = "
                + risultatoHeapSort.getCountCompare());
        System.out.println("Tempo impiegato dallo Heap Sort: " + elapsedTimeNano
                + " in nanosecondi");
        System.out.println("Tempo impiegato dallo Heap Sort: " + elapsedTime
                + " in millisecondi");
        
    }
}
