package it.unicam.cs.tesei.sorting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Algoritmo di ordinamento che usa uno heap binomiale.
 * 
 * @author Luca Tesei
 *
 * @param <E> la classe degli elementi da ordinare
 */
public class HeapSort<E extends Comparable<E>> implements SortingAlgorithm<E> {

    @Override
    public SortingAlgorithmResult<E> sort(List<E> l) {
        // Creo uno heap dalla lista
        Heap<E> h = new Heap<E>(l);
        // Creo la lista risultato vuota
        List<E> ris = new ArrayList<E>();
        while (h.size() > 0)
            // Estraggo il massimo dall'heap e lo aggiungo alla lista
            ris.add(h.extractMax());
        // Riordino la lista al contrario
        Collections.reverse(ris);
        // Restituisco il risultato
        return new SortingAlgorithmResult<E>(ris, h.getNCompare());
    }

    @Override
    public String getName() {
        return "HeapSort";
    }

}
