package it.unicam.cs.asdl1617.binarysearch;

import java.util.*;

/**
 * 
 * @author luca
 *
 * @param <E>
 */
public class BinarySearcher<E extends Comparable<E>> {
    /**
     * Ordina una lista in base all'ordinamento naturale ed esegue una ricerca
     * binaria di un certo elemento.
     * 
     * @param lista
     * @param elemento
     * @return true se l'elemento è presente, false altrimenti
     */
    public boolean search(List<E> lista, E elemento) {
        // Ordiniamo la lista
        Collections.sort(lista);
        // Chiamiamo la ricerca binaria ricorsiva
        return search(lista, elemento, 0, lista.size() - 1);
    }

    /*
     * Metodo privato ricorsivo
     */
    private boolean search(List<E> lista, E elemento, int start, int stop) {
        if (start > stop)
            // intervallo vuoto di ricerca
            return false;
        if (start == stop)
            if (lista.get(stop).equals(elemento))
                return true;
            else
                return false;
        // non sono nel caso base
        int posMid = (stop - start + 1) / 2;
        // l'elemento centrale si trova in posizione start + posMid
        int cmp = lista.get(start + posMid).compareTo(elemento);
        if (cmp == 0)
            // trovato!
            return true;
        // ricerca ricorsiva
        if (cmp < 0)
            // l'elemento può trovarsi nella sottolista destra
            return search(lista, elemento, start + posMid + 1, stop);
        else
            // l'elemento può trovarsi nella sottolista sinistra
            return search(lista, elemento, start, start + posMid - 1);
    }

}
