/**
 * 
 */
package it.unicam.cs.asdl1617.binarytrees;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * Classe che realizza uno heap binario su elementi non nulli senza ripetizioni.
 * 
 * @author luca
 *
 */
public class BinaryHeap<E extends Comparable<E>> {
    private List<E> heap;

    /**
     * Crea uno heap binario vuoto.
     */
    public BinaryHeap() {
        this.heap = new ArrayList<E>();
    }

    /**
     * Crea uno heap formato da una sola radice/foglia.
     * 
     * @param el
     */
    public BinaryHeap(E el) {
        if (el == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null nello heap");
        this.heap = new ArrayList<E>();
        this.heap.add(el);
    }

    /**
     * Crea uno heap a partire dalla lista di elementi data.
     * 
     * @param l
     *            lista che non contiene null e non contiene duplicati
     */
    public BinaryHeap(ArrayList<E> l) {
        // Creo un mio arraylist
        this.heap = new ArrayList<E>();
        if (l.size() == 0)
            return;
        // Copio la lista l nel mio arraylist
        this.heap.addAll(l);
        // Applico heapify dal primo elemento non foglia indietro fino 
        // alla radice
        for (int i = (this.heap.size() / 2) - 1; i >= 0; i--)
                this.heapify(i);
        }

    /*
     * Determina se il nodo dello heap che si trova in posizione i dell'array è
     * una foglia utilizzando il fatto che tutti gli elementi da
     * trunc(heap.size() / 2) in poi sono foglie
     */
    private boolean isFoglia(int i) {
        if (i >= this.heap.size() / 2 && i < this.heap.size())
            return true;
        else
            return false;
    }

    /*
     * Rende heap un albero per cui il nodo nella posizione i non è ben
     * posizionato rispetto alla proprietà dello heap. Si assume invece che i
     * due figli del nodo siano heap.
     */
    private void heapify(int i) {
        if (i < 0 || i >= this.heap.size()) {
            throw new IndexOutOfBoundsException(
                    "Heapify di un nodo non esistente");
        }
        // Indici del figlio destro e sinistro
        int leftIndex = 2 * i + 1;
        int rightIndex = 2 * i + 2;
        // Indice del nodo con valore massimo da determinare
        // tra i, leftIndex e rightIndex
        int maxIndex = i;
        // Confronto il padre con il figlio sinistro (se esiste)
        if (leftIndex < this.heap.size()) {
            int a = heap.get(i).compareTo(heap.get(leftIndex));
            if (a < 0) // Il figlio sinistro è maggiore del padre
                maxIndex = leftIndex;
        }
        // Qui maxIndex contiente l'indice del massimo tra il padre e il
        // figlio sinistro

        // Confronto il vincente con il figlio destro (se esiste)
        if (rightIndex < this.heap.size()) {
            int a = heap.get(maxIndex).compareTo(heap.get(rightIndex));
            if (a < 0) // Il figlio destro è maggiore del padre e del figlio
                       // sinistro
                maxIndex = rightIndex;
        }
        if (maxIndex != i) {
            // Effettuo lo scambio tra i e maxIndex
            E appoggio = heap.get(maxIndex);
            heap.set(maxIndex, heap.get(i));
            heap.set(i, appoggio);
            // Richiamo la procedura sul sottoalbero la cui radice è cambiata
            // in seguito allo scambio
            this.heapify(maxIndex);
        }
    }

    /*
     * Heapify --- implementazione errata!!
     */
    /*
    private void heapify(int i) {
        if (isFoglia(i))
            return; // Caso semplice
        // Controllo se l'elemento ha solo il figlio sinistro
        if (!isFoglia(2 * i + 2)) {
            // Il nodo ha solo il figlio sinistro
            int a = heap.get(i).compareTo(heap.get(2 * i + 1));
            if (a > 0)
                // Il padre è maggiore dell'unico figlio
                return;
            else {
                // Scambio
                E appoggio = heap.get(2 * i + 1);
                heap.set(2 * i + 1, heap.get(i));
                heap.set(i, appoggio);
                this.heapify(2 * i + 1);
                return;
            }
        }
        // Caso in cui il nodo i ha due figli
        int a = heap.get(i).compareTo(heap.get(2 * i + 1));
        int b = heap.get(i).compareTo(heap.get(2 * i + 2));
        int c = heap.get(2 * i + 1).compareTo(heap.get(2 * i + 2));
        if (a > 0)
            // Il padre è maggiore del figlio sinistro
            if (b > 0)
                // Il padre è maggiore dei figli
                return;
            else {
                // il padre è maggiore del figlio sinistro e minore del
                // figlio destro, quindi il figlio destro è il massimo
                E appoggio = heap.get(2 * i + 2);
                heap.set(2 * i + 2, heap.get(i));
                heap.set(i, appoggio);
                this.heapify(2 * i + 2);
            }
        else // Il padre è minore del figlio sinistro
        if (c > 0) {
            // Il figlio sinistro è maggiore del figlio destro
            // Il figlio sinistro è il massimo
            E appoggio = heap.get(2 * i + 1);
            heap.set(2 * i + 1, heap.get(i));
            heap.set(i, appoggio);
            this.heapify(2 * i + 1);
        } else {
            // Il padre è minore del figlio sinistro e il figlio sinistro
            // è minore del figlio destro, quindi il massimo è il figlio destro
            E appoggio = heap.get(2 * i + 2);
            heap.set(2 * i + 2, heap.get(i));
            heap.set(i, appoggio);
            this.heapify(2 * i + 2);
        }
        return;
    }
    */
    /**
     * Aggiunge un elemento a questo heap.
     * 
     * @param el elemento da aggiungere
     * @return true se l'elemento è stato aggiunto, false se era già presente
     */
    public boolean add(E el) {
        if (el == null)
            throw new NullPointerException(
                    "Tentativo di inserire un elemento null nello heap");
        if (this.heap.contains(el))
            // L'elemento è già presente e quindi non lo inserisco
            return false;
        // Aggiungo il nuovo elemento in coda
        this.heap.add(el);
        // Ciclo che confronta il nuovo elemento con il padre fino e si
        // scambia con esso fino a quando non trova un padre maggiore
        // Inizializzo i alla posizione attuale del nuovo nodo
        int i = this.heap.size() - 1;
        int padre = (i - 1) / 2;
        while (i > 0) { // Scorro fino a quando i ha un padre (escludo i == 0)
            int a = el.compareTo(this.heap.get(padre));
            if (a > 0) {
                // Il vecchio nodo padre "scende" in posizione i
                this.heap.set(i, this.heap.get(padre));
                // Aggiorno la posizione attuale del nuovo nodo i
                i = padre;
                // Aggiorno il padre
                padre = (i - 1) / 2;
            } else
                // Fermo il ciclo, la posizione i è quella corretta per il 
                // nuovo nodo
                break;
        }
        // Posiziono el nel posto giusto, indicato dal valore attuale di i
        this.heap.set(i, el);
        return true;
    }
    
    /**
     * Ritorna il massimo elemento dello heap.
     * 
     * @return il massimo elemento dello heap o null se lo heap è vuoto.
     */
    public E getMax() {
        if (this.heap.size() > 0) {
            return this.heap.get(0);
        } else
            return null;
    }

    /**
     * Estrae l'elemento massimo dallo heap.
     * 
     * @return l'elemento massimo o null se lo heap è vuoto
     */
    public E extractMax() {
        if (this.heap.size() == 0)
            return null;
        else if (this.heap.size() == 1) {
            E appoggio = this.heap.get(0);
            this.heap.remove(0);
            return appoggio;
        } else {
            // Faccio l'estrazione
            E appoggio = this.heap.get(0);
            // Copio l'ultimo elemento sul primo
            this.heap.set(0, this.heap.get(this.heap.size() - 1));
            // Elimino l'ultimo elemento
            this.heap.remove(this.heap.size() - 1);
            // Riaggiusto tutto
            this.heapify(0);
            return appoggio;
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        for (int i = 0; i < this.heap.size(); i++)
            sb.append(this.heap.get(i).toString() + " ");
        sb.append("]");
        return sb.toString();
    }
}
