package it.unicam.cs.asdl1617.dataset;

/**
 * Calcola la media e il massimo di un insieme di oggetti di classi che
 * implementano Measurable
 */
public class DataSetPolimorfo {
    // variabili istanza
    private double sum;

    private int count;

    private Measurable maximum;

    /**
     * Inizializza le variabili istanza con valori relativi ad un insieme di
     * dati vuoto
     */
    public DataSetPolimorfo() {
        sum = 0;
        maximum = null;
        count = 0;
    }

    /**
     * Aggiunge un oggetto all'insieme di dati
     * 
     * @param x
     *            un oggetto di una classe misurabile dal misuratore
     */
    public void add(Measurable x) {
        sum += x.getMeasure();
        if (count == 0 || maximum.getMeasure() < x.getMeasure())
            maximum = x;
        count++;
    }

    /**
     * Restituisce la media delle misure degli oggetti inseriti
     * 
     * @return la media, oppure 0 se non sono stati inseriti oggetti
     */
    public double getAverage() {
        if (count == 0)
            return 0;
        else
            return sum / count;
    }

    /**
     * Restituisce l'oggetto la cui misura Ë massima rispetto a tutti gli
     * oggetti inseriti
     * 
     * @return l'oggetto con misura massima o null se non sono stati inseriti
     *         oggetti
     */
    public Measurable getMaximum() {
        return maximum;
    }

}
