/**
 * 
 */
package it.unicam.cs.asdl1617.hashing;

/**
 * Contratto che impegna una classe a fornire una funzione di hash primaria che
 * utilizza hashCode() come chiave e ha come codominio l'intervallo [0,m-1] con
 * m fissato.
 * 
 * @author luca
 *
 */
public interface PrimaryHashFunction {
    /**
     * Rappresenta una funzione di hash che prende la chiave di un oggetto e
     * restituisce un valore in un intervallo [0,m-1].
     * 
     * @param m
     *            è il valore di m, limite superiore dell'intervallo di
     *            definizione del codominio della funzione.
     * @param o
     *            oggetto di cui calcolare la chiave con il metodo hashCode() e
     *            su cui poi calcolare la funzione di hash.
     * @return un valore tra 0 e m-1
     */
    public int hash(int m, Object o);

}
