/**
 * 
 */
package it.unicam.cs.asdl1617.hashing;

import java.util.ArrayList;

/**
 * Classe che realizza una tabella hash con gestione delle collisioni tramite
 * lista concatenata
 * 
 * @author luca
 *
 */
public class MyHash<E> {
    // Usiamo ArrayList invece che un array normale
    // per poter utilizzare agevolmente il generics <E>
    private ArrayList<E> table;

    // Dimensione della tabella hash
    private final int m;

    /**
     * Crea una tabella hash di dimensione data.
     * 
     * @param m
     *            un intero positivo, possibilmente un numero primo vicino a una
     *            potenza di 2.
     */
    public MyHash(int m) {
        this.m = m;
        this.table = new ArrayList<E>();
        for (int i = 0; i < m; i++)
            this.table.add(null);
    }

    /**
     * Inserisce un elemento nella tabella hash.
     * 
     * @param el
     *            l'elemento da inserire, non può essere null.
     */
    public void add(E el) {
        if (el == null)
            throw new NullPointerException("Tentativo di inserire un elemento"
                    + " null nella tabella hash");
        // Calcola l'hash
        int h = Math.abs(el.hashCode() % this.m);
        // Inserire l'elemento el in posizione h, ma gestendo
        // le possibili collisioni con una lista concatenata
        // TO FINISH
    }

}
