/**
 * 
 */
package it.unicam.cs.asdl1617.lists;

import java.util.Iterator;

/**
 * Implemnta una lista non immutabile come lista concatenata ad accesso
 * sequenziale.
 * 
 * @author luca
 *
 */
public class MyLinkedList<E> {
    /*
     * E' un puntatore al primo elemento della lista. Se questo puntatore è null
     * allora la lista è vuota.
     */
    private Link first;

    /*
     * E' un puntatore all'ultimo elemento della lista. E' null se la lista è
     * vuota.
     */
    private Link last;

    /*
     * Mantiene la dimensione della lista.
     */
    private int size;

    /**
     * 
     * @param newElement
     * @return
     */
    public boolean add(E newElement) {
        if (newElement == null) {
            throw new NullPointerException("Tentativo di inserire un "
                    + "oggetto null nella lista");
        }
        if (this.first == null) {
            // lista vuota
            Link newLink = new Link(newElement);
            this.first = newLink;
            this.last = newLink;
        } else {
            // lista non vuota
            Link newLink = new Link(newElement);
            this.last.next = newLink; // aggiorno la catena
            this.last = newLink; // aggiorno last
        }
        this.size++;
        return true;
    }

    /**
     * Restituisce la lunghezza attuale della lista.
     * 
     * @return
     */
    public int size() {
        return this.size;
    }

    /**
     * 
     * @return
     */
    public Iterator<E> iterator() {
        return new MyLinkedListIterator(this);
    }

    /**
     * 
     * @param index
     * @return
     */
    public E get(int index) {
        if (index < 0 || index >= this.size)
            throw new IndexOutOfBoundsException(
                    "Richiesta di elemento con indice inesistente.");
        // Controllo lista vuota
        if (this.first == null)
            throw new IndexOutOfBoundsException(
                    "Richiesta di elemento in una lista vuota.");
        Link p = this.first;
        // Nel caso di index = 0 il for non fa niente
        for (int i = 0; i < index; i++) {
            p = p.next;
        }
        // Il puntatore p punta esattamente all'elemento cercato
        return p.el;

    }

    /*
     * Gli oggetti della classe Link sono gli elementi della lista che vengono
     * concatenati sequenzialmente nello heap
     */
    private class Link {
        private E el;

        private Link next;

        /*
         * Costruisce un oggetto link senza successore
         */
        public Link(E newElement) {
            this.el = newElement;
            this.next = null;
        }
    }

    /*
     * Gli oggetti di questa classe sono iteratori semplici della lista
     * concatenata e implementano le operazioni di hasNext(), next() e remove()
     */
    private class MyLinkedListIterator implements Iterator<E> {
        /*
         * Puntatore all'oggetto prima della posizione del cursore. E' null
         * quando il cursore si trova all'inizio della lista
         */
        private Link lastNext;

        /*
         * Puntatore all'oggetto che si trova nella lista, prima dell'oggetto
         * 
         * che si trova prima del cursore. E' null nel caso in cui il cursore si
         * trova dopo il primo elemento della lista.
         */
        private Link beforeLastNext;

        /*
         * Puntatore alla lista su cui l'iteratore opera.
         */
        private MyLinkedList<E> list;

        /*
         * Serve per lanciare l'eccezione IllegalStateException - if the next
         * method has not yet been called, or the remove method has already been
         * called after the last call to the next method
         */
        private boolean nextDone;

        /*
         * Costruisce l'iteratore posizionando il cursore all'inizio della
         * lista.
         */
        public MyLinkedListIterator(MyLinkedList<E> list) {
            this.list = list;
            this.lastNext = null;
            this.beforeLastNext = null;
            this.nextDone = false;
        }

        @Override
        public boolean hasNext() {
            // Controllo il caso in cui il cursore è posizionato all'inizio
            if (this.lastNext == null)
                if (this.list.first != null)
                    // Il prossimo elemento esiste ed è il primo della lista
                    return true;
                else
                    // La lista è vuota, quindi non c'è un prossimo elemento
                    return false;
            // Il cursore non è posizionato all'inizio
            if (this.lastNext.next != null)
                return true;
            else
                return false; // Il cursore è posizionato alla fine della lista
        }

        @Override
        public E next() {
            // Controllo il caso in cui il cursore è posizionato all'inizio
            if (this.lastNext == null)
                if (this.list.first == null)
                    // Lancio eccezione
                    throw new IllegalArgumentException(
                            "E' stato chiamato next senza che ci sia un prossimo elemento");
                else { // Restituisco il primo elemento della lista
                    this.lastNext = this.list.first;
                    this.nextDone = true;
                    return this.list.first.el;
                }
            else { // Il cursore non è posizionato all'inizio
                   // Controllo se il cursore è alla fine
                if (this.lastNext.next == null)
                    // Lancio eccezione
                    throw new IllegalArgumentException(
                            "E' stato chiamato next senza che ci sia un prossimo elemento");
                else { // Il cursore non si trova né all'inizio nè alla fine
                       // Aggiorno beforeLastNext
                    this.beforeLastNext = this.lastNext;
                    // Aggiorno la posizione del cursore
                    this.lastNext = this.lastNext.next;
                    this.nextDone = true;
                    return this.lastNext.el;
                }
            }
        }
        
        /**
         * 
         */
        public void remove() {
            if (!nextDone)
                throw new IllegalStateException(
                        "Tentativo di fare remove o senza aver fatto next oppure due volte di seguito.");
            // Controllo il caso in cui il cursore è posizionato all'inizio
            if (this.lastNext == null)
                throw new IllegalArgumentException(
                        "E' stato chiamato remove senza che ci sia stata una chiamata a next precedente");
            // Controllo il caso in cui il cursore si trova esattamente dopo il
            // primo elemento
            if (this.lastNext == this.list.first)
                // Controllo il sottocaso in cui il primo elemento sia anche
                // l'ultimo.
                if (this.list.first == this.list.last) {
                    // Devo cancellare il primo elemento, che è anche l'ultimo
                    this.list.first = null;
                    this.list.last = null;
                    this.list.size = 0; // La lista è ora vuota
                    // Posiziono il cursore all'inizio della lista vuota
                    this.lastNext = null;
                    this.beforeLastNext = null;
                    this.nextDone = false; // Segnala che il remove è stato fatto
                } else {
                    // Devo cancellare il primo elemento, che però non è
                    // l'ultimo
                    this.list.first = this.list.first.next; // Aggiorno first
                    this.list.size--; // Aggiorno la size
                    // Aggiorno la posizione del cursore, che sarà di nuovo in
                    // testa alla lista
                    this.lastNext = null;
                    // Per sicurezza, ma non servirebbe:
                    this.beforeLastNext = null;
                    this.nextDone = false; // Segnala che il remove è stato fatto
                }
            else { // Il cursore non si trova dopo il primo elemento
                   // Controllo se il cursore si trova alla fine, perché in
                   // questo caso
                   // bisogna aggiornare il last della lista
                if (this.lastNext == this.list.last) {
                    // Tolgo l'ultimo elemento della lista e aggiorno last
                    this.lastNext = this.beforeLastNext;
                    this.list.last = this.beforeLastNext;
                    this.list.size--;
                    this.nextDone = false; // Segnala che il remove è stato fatto
                } else {
                    // Il cursore non si trova nè dopo il primo elemento nè 
                    // alla fine della lista
                    // Collego l'elemento prima di quello elminato con quello 
                    // dopo quello eliminato
                    this.beforeLastNext.next = this.lastNext.next;
                    this.lastNext = this.beforeLastNext;
                    this.list.size--;
                    this.nextDone = false; // Segnala che il remove è stato fatto   
                }
            }
        }
    }
}
