/**
 * 
 */
package it.unicam.cs.asdl1617.lists;

/**
 * Classe che implementa liste concatenate con una struttura dati ricorsiva.
 * 
 * @author luca
 *
 */
public class RecList<E> {
    /*
     * Primo elemento di questa lista (se non vuota)
     */
    private final E first;

    /*
     * Sottolista di questa lista (se non vuota)
     */
    private final RecList<E> rest;

    /*
     * La lista vuota "nil" è caratterizzata da un first e un rest entrambi null
     */

    /**
     * Costruisce la lista vuota nil. E' l'unico modo di costruire la lista nil.
     */
    public RecList() {
        this.first = null;
        this.rest = null;
    }

    /**
     * Costruisce una lista a partire da un elemento e una sottolista.
     * L'elemento non può essere null e la sottolista può essere nil, ma non può
     * essere null. E' l'equivalente dell'operazione funzionale
     * cons(first,rest).
     * 
     * @param first
     *            elemento in testa alla nuova lista
     * @param rest
     *            sottolista, può essere nil
     * 
     * @throws NullPointerException
     *             se fist o rest sono null.
     */
    public RecList(E first, RecList<E> rest) {
        if (first == null)
            throw new NullPointerException("Tentativo di "
                    + "costruire una lista con elemento iniziale null");
        if (rest == null)
            throw new NullPointerException("Tentativo di "
                    + "costruire una lista con sottolista null");
        this.first = first;
        this.rest = rest;
    }

    /**
     * Dice se questa lista è nil.
     * 
     * @return true se questa lista è nil, false altrimenti.
     */
    public boolean isNil() {
        return this.first == null && this.rest == null;
    }

    /**
     * Restituisce il puntatore all'oggetto in testa alla lista.
     * 
     * @return il puntatore all'oggetto in testa alla lista.
     */
    public E first() {
        return this.first;
    }

    /**
     * Restituisce la sottolista di questa lista.
     * 
     * @return la sottolista di questa lista.
     */
    public RecList<E> rest() {
        return this.rest;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((first == null) ? 0 : first.hashCode());
        result = prime * result + ((rest == null) ? 0 : rest.hashCode());
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof RecList))
            return false;
        RecList other = (RecList) obj;
        if (first == null) {
            if (other.first != null)
                return false;
        } else if (!first.equals(other.first))
            return false;
        if (rest == null) {
            if (other.rest != null)
                return false;
        } else if (!rest.equals(other.rest))
            return false;
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (this.isNil())
            return "[ ]";
        else
            return "[" + this.first.toString() + this.rest.recToString() + "]";
    }

    /*
     * Metodo ricorsivo per stampare la lista nel formato ,el,el,el...
     */
    private String recToString() {
        if (this.isNil())
            return "";
        else
            return "," + this.first.toString() + this.rest.recToString();
    }

    /**
     * Restituisce la lunghezza di questa lista.
     * 
     * @return la lunghezza di questa lista
     */
    public int size() {
        if (this.isNil())
            return 0;
        else
            return 1 + this.rest.size();
    }

    /**
     * Ricerca se un certo elemento è presente o no nella lista
     * 
     * @param o
     *            l'elemento di confronto da cercare
     * @return true se un elemento che è equals a o è presente in questa lista
     */
    public boolean contains(E o) {
        if (this.isNil())
            return false;
        // Se sono qui, non sono la lista vuota
        /*
         * Controllo se il primo elemento della lista è uguale all'elemento
         * cercato
         */
        if (this.first.equals(o))
            return true;
        else
            return this.rest.contains(o);
    }

    /**
     * Restituisce questa lista dove la prima occorrenza di un certo elemento è
     * stata eliminata. Se l'elemento non è presente, la lista ritornata sarà la
     * stessa.
     * 
     * @param o
     *            l'elemento di confronto per l'eliminazione
     * @return la lista dove la prima occorrenza di un elemento equals a o è
     *         stata rimossa.
     */
    public RecList<E> removeFirst(E o) {
        if (this.isNil())
            return this;
        // Se sono qui non sono la lista vuota
        if (this.first.equals(o))
            return this.rest; // Tolgo l'elemento first
        else
            return // Restituisco il cons tra il mio first e
                   // il risultato della chiamata ricorsiva
            new RecList<E>(this.first, this.rest.removeFirst(o));
    }

    /**
     * Restituisce questa lista dove tutte le occorrenze di un certo elemento
     * sono state eliminate. Se l'elemento non è presente, la lista ritornata
     * sarà la stessa.
     * 
     * @param o
     *            l'elemento di confronto per l'eliminazione
     * @return la lista dove tutte le occorrenza di un elemento equals a o sono
     *         state rimosse.
     */
    public RecList<E> removeAll(E o) {
        if (this.isNil())
            return this;
        // Se sono qui non sono la lista vuota
        if (this.first.equals(o))
            return this.rest.removeAll(o); // Tolgo l'elemento first e continuo
                                           // la rimozione!
        else
            return // Restituisco il cons tra il mio first e
                   // il risultato della chiamata ricorsiva
            new RecList<E>(this.first, this.rest.removeAll(o));
    }

    /**
     * 
     * @param otherList
     * @return
     */
    public RecList<E> append(RecList<E> otherList) {
        if (this.isNil())
            return otherList;
        // questa lista non è nil
        return new RecList<E>(this.first, this.rest.append(otherList));

    }

    /**
     * Restituisce l'elemento della lista in una certa posizione. La prima
     * posizione ha indice zero e l'ultima ha indice
     * <code>this.size() - 1</code>.
     * 
     * @param i
     *            la posizione
     * @return l'elemento in posizione i.
     */
    public E get(int i) {
        if (i < 0)
            // sono stato chiamato con un numero negativo
            throw new IndexOutOfBoundsException("Tentativo di ottenere"
                    + " un elemento di una lista che non esiste.");
        // l'indice non è negativo
        if (i == 0)
            if (this.isNil())
                throw new IndexOutOfBoundsException("Tentativo di ottenere"
                        + " un elemento di una lista che non esiste.");
            else
                return this.first;
        // Se sono qui i > 0
        // Se sono nil, è stato chiamato get su un indice maggiore di size() - 1
        if (this.isNil())
            throw new IndexOutOfBoundsException("Tentativo di ottenere"
                    + " un elemento di una lista che non esiste.");
        else
            // Richiamo il metodo ricorsivamente decrementando la i
            return this.rest.get(i - 1);
    }
    
    /**
     * 
     * @param newEl
     * @return
     */
    public RecList<E> add(E newEl) {
        return this.append( // faccio l'append di questa lista con 
                new RecList<E>( // la lista formata solo dal nuovo elemento 
                        newEl, // che è quindi un cons dell'elemento con 
                        new RecList<E>())); // nil
        
    }
}
