/**
 * 
 */
package it.unicam.cs.asdl1617.matrix;

import java.util.Arrays;

/**
 * 
 * Classe che rappresenta una matrice n x m di numeri a virgola mobile.
 * 
 * @author luca
 *
 */
public class Matrix {

    private final double m[][];

    /**
     * Costruisce una matrice con un certo numero di righe p e un certo numero
     * di colonne p. Non sono ammesse matrici con p o q uguali a 0. Sono invece
     * ammessi vettori riga o vettori colonna.
     * 
     * @param m
     */
    public Matrix(double m[][]) {
        this.m = m;
    }

    /**
     * Restituisce il numero di righe di questa matrice.
     * 
     * @return
     */
    public int getRows() {
        return this.m.length;
    }

    /**
     * Restituisce il numero di colonne di questa matrice.
     * 
     * @return
     */
    public int getColumns() {
        return this.m[0].length;
    }

    /**
     * Restituisce una nuova matrice che è il risultato del prodotto di questa
     * matrice per la matrice passata come parametro.
     * 
     * @param other
     *            la matrice con cui fare il prodotto
     * @return la matrice prodotto this x other
     * 
     * @throws IllegalArgumentException
     *             se la matrice other non è compatibile per fare il prodotto
     *             con questa matrice
     */
    public Matrix multiply(Matrix other) {
        // TODO
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(m);
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Matrix))
            return false;
        Matrix other = (Matrix) obj;
        if (!Arrays.deepEquals(m, other.m))
            return false;
        return true;
    }

}
