/**
 * 
 */
package it.unicam.cs.asdl1617.matrix;

import java.util.List;

/**
 * Classe attore che rappresenta un solutore del problema di determinare una
 * parentesizzazione ottima per moltiplicare una sequenza di matrici.
 * 
 * @author luca
 *
 */
public class MatrixMultiplicationSolver {

    // Sequenza delle matrici da moltiplicare
    private List<Matrix> sequence;

    // matrice dei costi ottimali
    private int c[][];

    // matrice delle scelte k ottimali
    private int s[][];

    /*
     * vettore di comodo che contiene la sequenza delle dimensioni delle matrici
     * in this.sequence. Ad esempio se ho A1, A2, A3 e le dimensioni di A1 sono
     * 30 x 10, le dimensioni di A2 sono 10 x 50 e le dimensioni di A3 sono 50 x
     * 100 allora il vettore p sarà uguale a [30,10,50,100]
     */
    private int p[];

    /**
     * Costruisce un risolutore per una data sequenza di matrici da
     * moltiplicare.
     * 
     * @param sequence
     *            la sequenza delle matrici da moltiplicare, lunga almeno 3.
     */
    public MatrixMultiplicationSolver(List<Matrix> sequence) {
        // TODO controllare che la sequenza sia non null
        // TODO controllare che la sequenza sia lunga almeno 3
        // TODO controllare che la sequenza contenga matrici compatibili per la
        // moltiplicazione
        this.sequence = sequence;
        // TODO creare e inizializzare il vettore p
        this.init(); // crea e calcola le matrici m e s
    }

    /**
     * Restituisce il numero minimo di moltiplicazioni per effettuare la
     * moltiplicazione delle matrici.
     */
    public int getOptimalValue() {
        // TODO
        return 0;

    }

    /**
     * Restituisce una stringa che contiene la parentesizzazione ottima.
     * 
     * @return
     */
    public String getOptimalParenthesising() {
        // TODO
        return null;
    }

    /**
     * Restituisce il risultato della moltiplicazione utilizzando la
     * parentesizzazione minima.
     * 
     * @return
     */
    public Matrix getMultiplication() {
        // TODO
        return null;
    }

    /*
     * Inizializza e calcola le matrici c ed s
     */
    private void init() {
        // Creo le matrici
        int n = this.sequence.size();
        this.c = new int[n][n];
        this.s = new int[n][n];
        int l, i, j, k, d;
        // inizializzo la diagonale principale di c
        for (l = 0; l < n; l++)
            this.c[l][l] = 0;
        // faccio scorrere j sulla prima riga da 1 a n
        for (j = 1; j < n; j++) {
            i = 0;
            // d è la lunghezza della diagonale che parte dalla posizione
            // [0][j]
            d = n - j;
            // Cammino lungo la diagonale che parte da [0][j]
            for (l = 0; l < d; l++) {
                // Vado a riempire la posizione [i+l][j+l]
                // camminando lungo la diagonale con passo l
                // Inserisco un valore iniziale equivalente a + infinito per
                // determinare il minimo scorrendo tutti i valori
                this.c[i + l][j + l] = Integer.MAX_VALUE;
                // Confronto tutti i possibili valori per k che varia
                // nell'intervallo [i+l, j+l-1]
                // e determino il k per cui c'è un valore minimo
                for (k = i + l; k < j + l; k++) {
                    // Calcolo il valore per questo k
                    int value = this.c[i + l][k] + this.c[k + 1][j + l]
                            + this.p[i + l] * this.p[k + 1] * this.p[j + l + 1];
                    // Confronto il valore per questo k con il minimo corrente
                    if (value < this.c[i + l][j + l]) {
                        // Sostituisco il valore corrente del minimo
                        this.c[i + l][j + l] = value;
                        // Sostituisco il valore corrente del punto k in cui
                        // inserisco la parentesi
                        this.s[i + l][j + l] = k;
                    }
                }
                // this.c[i+l][j+l] contiene il numero minimo di moltiplicazioni
                // per calcolare il prodotto di matrici da i+l a j+l
                // this.s[i+l][j+l] contiene il punto in cui spezzare le
                // matrici da i+l a j+l in due sottoespressioni da moltiplicare
            }
        }
    }
}
