/**
 * 
 */
package it.unicam.cs.asdl1617.graphs;

import java.util.Set;

/**
 * @author luca
 *
 */
public class PrimMSPTest {

    /**
     * @param args
     */
    public static void main(String[] args) {
        Graph<String,WeighedEdge> g = 
                new GraphListUndirected<String,WeighedEdge>();
        g.addNode("a");
        g.addNode("b");
        g.addNode("c");
        g.addNode("d");
        g.addNode("e");
        g.addNode("f");
        g.addNode("g");
        g.addNode("h");
        g.addNode("i");
        g.addEdge("a", "b", new WeighedEdge(4));
        g.addEdge("a", "h", new WeighedEdge(8));
        g.addEdge("b", "h", new WeighedEdge(11));
        g.addEdge("b", "c", new WeighedEdge(8));
        g.addEdge("c", "i", new WeighedEdge(2));
        g.addEdge("c", "d", new WeighedEdge(7));
        g.addEdge("c", "f", new WeighedEdge(4));
        g.addEdge("d", "f", new WeighedEdge(14));
        g.addEdge("d", "e", new WeighedEdge(9));
        g.addEdge("e", "f", new WeighedEdge(10));
        g.addEdge("f", "g", new WeighedEdge(2));
        g.addEdge("g", "i", new WeighedEdge(6));
        g.addEdge("g", "h", new WeighedEdge(1));
        g.addEdge("h", "i", new WeighedEdge(7));
        PrimMSP<String,WeighedEdge> alg = new PrimMSP<String,WeighedEdge>();
        Set<Edge<String,WeighedEdge>> mst = alg.findMSP(g, "a");
        for (Edge<String,WeighedEdge> a : mst) {
            System.out.println("Arco (" + a.getLabel1() + ") -- " +
             a.getLabel().getWeight() + " --> (" + a.getLabel2() + ")");
        }
            
        
        
        

    }

}
