/**
 * 
 */
package it.unicam.cs.asdl1617.graphs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * 
 * Classe singoletto che implementa l'algoritmo di Prim per trovare un Minimum
 * Spanning Tree di un grafo pesato.
 * 
 * @author luca
 *
 */
public class PrimMSP<V, E extends Weight> {

    public Set<Edge<V, E>> findMSP(Graph<V, E> g, V s) {
        // Definisco un comparatore che ordina gli archi in base
        // al peso
        Comparator<Edge<V, E>> comparator = new Comparator<Edge<V, E>>() {
            public int compare(Edge<V, E> e1, Edge<V, E> e2) {
                Double p1 = e1.getLabel().getWeight();
                Double p2 = e2.getLabel().getWeight();
                return p1.compareTo(p2);
            }
        };
        // nodo corrente
        V currentNode = s;
        // Insieme dei nodi ancora da visitare
        Set<V> nodesToVisit = new HashSet<V>();
        // Inizializzo l'insieme dei nodi ancora da visitare
        for (V n : g.getNodes()) {
            if (!n.equals(s)) {
                nodesToVisit.add(n);
            }
        }
        // Insieme che contiene la soluzione parziale,
        // cioè il minimum spanning tree, che parte
        // dalla soluzione parziale banale vuota
        Set<Edge<V, E>> msp = new HashSet<Edge<V, E>>();
        // Insieme di nodi che ad ogni passo contiene il taglio
        // corrente. Per poter estrarre il minimo in maniera
        // efficiente usiamo un SortedSet
        SortedSet<Edge<V, E>> taglio = new TreeSet<Edge<V, E>>(comparator);
        // Inizializzo il taglio: inserisco tutti gli archi collegati alla
        // sorgente, tranne i cappi
        for (Edge<V, E> a : g.getEdges(s)) {
            // Inserisco tutti gli archi che non sono cappi
            if (!a.getLabel1().equals(a.getLabel2()))
                taglio.add(a);
        }
        // Imposto il ciclo di soluzione
        do {
            // ho già il nodo corrente
            // ho già il taglio
            // determino l'arco leggero, cioè quello con peso minimo
            // dentro l'insieme taglio
            Edge<V, E> arcoLeggero = taglio.first();
            // sposto l'arco leggero dal taglio alla soluzione
            taglio.remove(arcoLeggero);
            msp.add(arcoLeggero);
            // Scopro un nuovo nodo
            V newNode;
            if (currentNode.equals(arcoLeggero.getLabel1()))
                newNode = arcoLeggero.getLabel2();
            else
                newNode = arcoLeggero.getLabel1();
            // Tolgo il nodo appena scoperto dai nodi ancora da visitare
            nodesToVisit.remove(newNode);
            // Tolgo dal taglio tutti gli archi che ancora contengono un
            // riferimento a newNode
            // Poiché sto filtrando l'insime taglio devo usare
            // un iteratore
            Iterator<Edge<V,E>> i = taglio.iterator();
            Edge<V,E> a;
            while (i.hasNext()) {
                a = i.next();
                if (a.getLabel1().equals(newNode) || 
                        a.getLabel2().equals(newNode))
                    i.remove();
            }
            // Aggiungo al taglio tutti gli archi connessi a
            // newNode tranne quelli che connettono newNode con
            // nodi già scoperti
            Set<Edge<V,E>> connectedToNewNode = g.getEdges(newNode);
            for (Edge<V,E> a1 : connectedToNewNode) {
                // Determino se a1 connette newNode con un nodo
                // ancora da visitare
                if (nodesToVisit.contains(a1.getLabel1()) ||
                        nodesToVisit.contains(a1.getLabel2()))
                        // aggiungo l'arco al taglio
                        taglio.add(a1);
            }
            // Ho aggiornato il taglio                   
            // Aggiorno currentNode
            currentNode = newNode;
        } while (!nodesToVisit.isEmpty());
        // Posso dare la soluzione
        return msp;
    }
}
