package it.unicam.cs.tesei.regine;

import java.util.List;

/**
 * Risolve il problema delle otto regine
 * 
 * @author Luca Tesei
 *
 */
public class EightQueens {

    private int[][] m = new int[8][8]; // Scacchiera

    private int[] r = new int[8]; // Posizioni delle regine sulle colonne, -1 se
                                  // non posizionata

    /**
     * Costruisce un oggetto risolutore del problema delle otto regine
     */
    public EightQueens() {
        for (int i = 0; i < 8; i++)
            for (int j = 0; j < 8; j++)
                m[i][j] = 0;
        for (int i = 0; i < 8; i++)
            r[i] = -1;
    }

    /*
     * Inserisce una regina nella scacchiera in posizione i,j marcando tutte le
     * caselle che la nuova regina influenza
     */
    private void putQueen(int i, int j) {
        // Aumento di 1 la casella in cui si trova la regina
        m[i][j]++;
        // Aumento di 1 tutte le caselle nella riga i tranne quella in cui si
        // trova la regina, cioè la colonna j
        for (int k = 0; k < 8; k++)
            if (k != j)
                m[i][k]++;
        // Aumento di 1 tutte le caselle nella colonna j tranne quella in cui si
        // trova la regina, cioè la riga i
        for (int k = 0; k < 8; k++)
            if (k != i)
                m[k][j]++;
        // Diagonale destra superiore
        int h = 1;
        while ((i - h >= 0) & (j - h >= 0)) {
            m[i - h][j - h]++;
            h++;
        }
        // Diagonale destra inferiore
        h = 1;
        while ((i + h < 8) & (j + h < 8)) {
            m[i + h][j + h]++;
            h++;
        }
        // Diagonale sinistra superiore
        h = 1;
        while ((i - h >= 0) & (j + h < 8)) {
            m[i - h][j + h]++;
            h++;
        }
        // Diagonale sinistra inferiore
        h = 1;
        while ((i + h < 8) & (j - h >= 0)) {
            m[i + h][j - h]++;
            h++;
        }
    }

    /*
     * Toglie una regina dalla posizione i,j togliendo il mark precedentemente
     * inserito
     */
    private void removeQueen(int i, int j) {
        // Decremento di 1 la casella in cui si trova la regina
        m[i][j]--;
        // Decremento di 1 tutte le caselle nella riga i tranne quella in cui si
        // trova la regina, cioè la colonna j
        for (int k = 0; k < 8; k++)
            if (k != j)
                m[i][k]--;
        // Decremento di 1 tutte le caselle nella colonna j tranne quella in cui
        // si
        // trova la regina, cioè la riga i
        for (int k = 0; k < 8; k++)
            if (k != i)
                m[k][j]--;
        // Diagonale destra superiore
        int h = 1;
        while ((i - h >= 0) & (j - h >= 0)) {
            m[i - h][j - h]--;
            h++;
        }
        // Diagonale destra inferiore
        h = 1;
        while ((i + h < 8) & (j + h < 8)) {
            m[i + h][j + h]--;
            h++;
        }
        // Diagonale sinistra superiore
        h = 1;
        while ((i - h >= 0) & (j + h < 8)) {
            m[i - h][j + h]--;
            h++;
        }
        // Diagonale sinistra inferiore
        h = 1;
        while ((i + h < 8) & (j - h >= 0)) {
            m[i + h][j - h]--;
            h++;
        }
    }

    /**
     * Restituisce la prima soluzione trovata con la strategia di backtracking
     * implementata.
     * 
     * @return un array contenente la posizione di ognuna delle otto regine
     *         nelle otto colonne della scacchiera.
     */
    public int[] findFirstSolution() {
        // Controllo se la soluzione è già stata trovata.
        if (this.r[0] != -1)
            return this.r;
        // Altrimenti la cerco.
        if (this.recFind(0)) {
            return this.r;
        } else
            return null;
    }

    /*
     * Metodo privato ricorsivo per la risoluzione. Implementa una esplorazione
     * esaustiva delle configurazioni possibile generata partendo dalla colonna
     * più a sinistra fino alla colonna più a destra e, all'interno di ogni
     * colonna, dalla riga più in alto alla riga più in basso. In caso di
     * fallimento fa il backtracking alla ultima configurazione considerata
     * prendendo la strada successiva secondo l'ordine dato di generazione delle
     * configurazioni.
     */
    private boolean recFind(int j) {
        int k = 0;
        // Cerco una posizione possibile nella colonna j
        while (k < 8 && m[k][j] > 0)
            k++;
        if (k == 8)
            // Non c'è nessuna posizione possibile nella colonna j in cui posso
            // inserire una regina.
            return false;
        while (k < 8) {
            // posso mettere la regina in posizione k,j
            putQueen(k, j);
            this.r[j] = k;
            if (j == 7) {
                // Ho trovato la soluzione perché è l'ultima regina
                return true;
            } else {
                // Non è l'ultima regina, quindi chiamo la regina successiva
                if (this.recFind(j + 1))
                    // Ho trovato la soluzione ed è una regina intermedia
                    return true;
                else { // La regina j+1 e le successive hanno fallito
                       // Continuo l'esplorazione in questa colonna j
                       // Tolgo la regina dalla posizione k
                    this.removeQueen(k, j);
                    this.r[j] = -1;
                    // Cerco un'altra posizione possibile
                    k++;
                    while (k < 8 && m[k][j] > 0)
                        k++;
                    if (k == 8)
                        // Non c'è nessuna ulteriore posizione possibile per una
                        // regina in questa colonna. Fallisco innescando il
                        // backtracking nel posizionamento della regina nella
                        // colonna precedente j-1.
                        return false;
                    else
                        // Ho trovato una posizione successiva possibile in
                        // questa colonna e quindi continuo il ciclo per
                        // esplorare questa possibile posizione.
                        continue;
                }
            }
        }
        return false; // Codice non raggiungibile
    }

    /**
     * Trova tutte le soluzioni possibili del problema delle otto regine.
     * 
     * @return una lista di array con tutte le soluzioni possibili al problema.
     */
    public List<int[]> findAllSolutions() {
        // TODO
        return null;
    }

}
