package it.unicam.cs.asdl1819.aule;

import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Aula implements Comparable<Aula> {
    // Identificativo unico di un'aula
    private final String nome;

    // Insieme delle prenotazioni per quest'aula, in ordine cronologico
    private SortedSet<Prenotazione> prenotazioni;

    public Aula(String nome) {
        this.nome = nome;
        this.prenotazioni = new TreeSet<Prenotazione>();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((nome == null) ? 0 : nome.hashCode());
        result = prime * result
                + ((prenotazioni == null) ? 0 : prenotazioni.hashCode());
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Aula))
            return false;
        Aula other = (Aula) obj;
        if (nome == null) {
            if (other.nome != null)
                return false;
        } else if (!nome.equals(other.nome))
            return false;
        if (prenotazioni == null) {
            if (other.prenotazioni != null)
                return false;
        } else if (!prenotazioni.equals(other.prenotazioni))
            return false;
        return true;
    }

    @Override
    public int compareTo(Aula o) {
        // L'ordine si basa sul nome
        return this.nome.compareTo(o.nome);
    }

    /**
     * @return the nome
     */
    public String getNome() {
        return nome;
    }

    /**
     * @return the prenotazioni
     */
    public SortedSet<Prenotazione> getPrenotazioni() {
        return prenotazioni;
    }

    /**
     * Determina se l'aula è libera.
     * 
     * TODO da migliorare con il controllo del numero di ore
     * 
     * @param inizio
     *                   inizio dello slot da controllare
     * @return true se l'aula è libera all'inizio dello slot
     */
    public boolean isFree(GregorianCalendar inizio) {
        Prenotazione p = null;
        GregorianCalendar gc = null;
        // Scorre l'insieme ordinato di prenotazioni e
        // vede se la data e l'ora sono occupate
        Iterator<Prenotazione> i = prenotazioni.iterator();
        // Cerco una prenotazione nella stessa data e
        // nella stessa ora
        boolean trovato = false;
        boolean interrompi = false;
        // scorrimento ordinato
        while (i.hasNext() && !trovato && !interrompi) {
            p = i.next();
            gc = p.getInizio();
            if (gc.equals(inizio))
                trovato = true;
            else if (gc.compareTo(inizio) > 0)
                // Ho superato la data senza aver trovato
                interrompi = true;
        }
        if (trovato)
            return false;
        else
            return true;
    }

    /**
     * Prenota l'aula senza controllare le sovrapposizioni.
     * 
     * TODO migliorare 
     * 
     * @param inizio
     *                        inizio della prenotazione
     * @param numeroDiOre
     *                        durata in ore
     */
    public void prenota(GregorianCalendar inizio, int numeroDiOre) {
        Prenotazione p = new Prenotazione(this, inizio, numeroDiOre);
        this.prenotazioni.add(p);
    }
}
