package it.unicam.cs.asdl1819.aule;

import java.util.GregorianCalendar;

public class Prenotazione implements Comparable<Prenotazione> {
    private final Aula aula;

    private final GregorianCalendar inizio;

    private final int numeroDiOre;

    /**
     * Costruisce una prenotazione.
     * 
     * @param aula
     *                        aula a cui si riferisce questa prenotazione
     * @param inizio
     *                        ora di inizio della prenotazione
     * @param numeroDiOre
     *                        numero di ore di durata della prenotazione
     */
    public Prenotazione(Aula aula, GregorianCalendar inizio, int numeroDiOre) {
        this.aula = aula;
        this.inizio = inizio;
        this.numeroDiOre = numeroDiOre;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((aula == null) ? 0 : aula.hashCode());
        result = prime * result + ((inizio == null) ? 0 : inizio.hashCode());
        result = prime * result + numeroDiOre;
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Prenotazione))
            return false;
        Prenotazione other = (Prenotazione) obj;
        if (aula == null) {
            if (other.aula != null)
                return false;
        } else if (!aula.equals(other.aula))
            return false;
        if (inizio == null) {
            if (other.inizio != null)
                return false;
        } else if (!inizio.equals(other.inizio))
            return false;
        if (numeroDiOre != other.numeroDiOre)
            return false;
        return true;
    }

    @Override
    public int compareTo(Prenotazione o) {
        // Le prenotazioni sono ordinate in base alla data di inizio e, in
        // subordine dal numero di ore e dall'aula, in modo da rendere
        // l'ordinamento compatibile con equals
        int cmpInizio = this.inizio.compareTo(o.inizio);
        if (cmpInizio != 0)
            return cmpInizio;
        int cmpDurata = this.numeroDiOre - o.numeroDiOre;
        if (cmpDurata != 0)
            return cmpDurata;
        return this.aula.compareTo(o.aula);
    }

    /**
     * @return the aula
     */
    public Aula getAula() {
        return aula;
    }

    /**
     * @return the inizio
     */
    public GregorianCalendar getInizio() {
        return inizio;
    }

    /**
     * @return the numeroDiOre
     */
    public int getNumeroDiOre() {
        return numeroDiOre;
    }

}
